/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.ThreadPool;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-threadpool")
@Scoped(value=PerLookup.class)
@I18n(value="create.threadpool")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateThreadpool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateThreadpool.class);
    @Param(name="maxthreadpoolsize", optional=true)
    String maxthreadpoolsize;
    @Param(name="minthreadpoolsize", optional=true)
    String minthreadpoolsize;
    @Param(name="idletimeout", optional=true)
    String idletimeout;
    @Param(name="workqueues", optional=true)
    String workqueues;
    @Param(name="maxqueuesize", optional=true)
    String maxQueueSize;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="threadpool_id", primary=true)
    String threadpool_id;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Configs configs;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        com.sun.enterprise.config.serverbeans.Cluster cluster;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (targetServer != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        ThreadPools threadPools = this.config.getThreadPools();
        for (ThreadPool pool : threadPools.getThreadPool()) {
            if (!pool.getName().equals(this.threadpool_id)) continue;
            report.setMessage(localStrings.getLocalString("create.threadpool.duplicate", "Thread Pool named {0} already exists.", new Object[]{this.threadpool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.workqueues != null) {
            report.setMessage(localStrings.getLocalString("create.threadpool.deprecated.workqueues", "Deprecated Syntax: --workqueues option is deprecated for create-threadpool command."));
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                public Object run(ThreadPools param) throws PropertyVetoException, TransactionFailure {
                    ThreadPool newPool = (ThreadPool)param.createChild(ThreadPool.class);
                    newPool.setName(CreateThreadpool.this.threadpool_id);
                    newPool.setMaxThreadPoolSize(CreateThreadpool.this.maxthreadpoolsize);
                    newPool.setMinThreadPoolSize(CreateThreadpool.this.minthreadpoolsize);
                    newPool.setMaxQueueSize(CreateThreadpool.this.maxQueueSize);
                    newPool.setIdleThreadTimeoutSeconds(CreateThreadpool.this.idletimeout);
                    param.getThreadPool().add(newPool);
                    return newPool;
                }
            }, (ConfigBeanProxy)threadPools);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            String str = e.getMessage();
            String def = "Creation of: " + this.threadpool_id + "failed because of: " + str;
            String msg = localStrings.getLocalString("create.threadpool.failed", def, new Object[]{this.threadpool_id, str});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

