/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;

public class ReadableArchiveScannerAdapter
implements ArchiveAdapter {
    final ReadableArchive archive;

    public ReadableArchiveScannerAdapter(ReadableArchive archive) {
        this.archive = archive;
    }

    public URI getURI() {
        return this.archive.getURI();
    }

    public Manifest getManifest() throws IOException {
        return this.archive.getManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEachEntry(ArchiveAdapter.EntryTask entryTask) throws IOException {
        Enumeration entries = this.archive.entries();
        while (entries.hasMoreElements()) {
            String explodedName;
            String name = (String)entries.nextElement();
            if (name.endsWith(".class")) {
                InputStream is = null;
                try {
                    is = this.archive.getEntry(name);
                    ArchiveAdapter.Entry entry = new ArchiveAdapter.Entry(name, this.archive.getEntrySize(name), false);
                    entryTask.on(entry, is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            if (!name.endsWith(".jar") || this.archive.exists(explodedName = name.replaceAll("[/ ]", "__").replace(".jar", "_jar"))) continue;
            ReadableArchive subArchive = null;
            try {
                subArchive = this.archive.getSubArchive(name);
                if (subArchive == null) continue;
                ReadableArchiveScannerAdapter adapter = new ReadableArchiveScannerAdapter(subArchive);
                adapter.onEachEntry(entryTask);
            }
            finally {
                if (subArchive == null) continue;
                subArchive.close();
            }
        }
    }

    public void close() throws IOException {
    }
}

