/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.Ports;
import org.glassfish.kernel.embedded.PortImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class PortsImpl
implements Ports {
    @Inject
    NetworkConfig network;
    @Inject
    Habitat habitat;
    final Map<Integer, Port> ports = new HashMap<Integer, Port>();

    public Port createPort(int number) throws IOException {
        return this.createPort((Integer)number);
    }

    private Port createPort(Integer portNumber) throws IOException {
        for (NetworkListener nl : this.network.getNetworkListeners().getNetworkListener()) {
            if (!nl.getPort().equals(portNumber.toString())) continue;
            throw new IOException("Port " + portNumber + " is already configured");
        }
        for (Integer pn : this.ports.keySet()) {
            if (!pn.equals(portNumber)) continue;
            throw new IOException("Port " + portNumber + " is alredy open");
        }
        PortImpl port = (PortImpl)this.habitat.getComponent(PortImpl.class);
        port.setPortNumber(portNumber);
        this.ports.put(portNumber, port);
        return port;
    }

    public Collection<Port> getPorts() {
        return this.ports.values();
    }

    public void remove(Port port) {
        this.ports.remove(port.getPortNumber());
    }
}

