/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.embeddable.Deployer;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@ContractProvided(value=Deployer.class)
public class DeployerImpl
implements Deployer {
    @Inject
    CommandRunner commandRunner;
    @Inject
    Habitat habitat;

    public String deploy(File archive) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", archive.getName());
        return this.deploy(archive, params);
    }

    public String deploy(File archive, Map<String, String> params) {
        ActionReport actionReport = this.createActionReport();
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("deploy", actionReport);
        ParameterMap commandParams = new ParameterMap();
        for (Map.Entry<String, String> e : params.entrySet()) {
            commandParams.add((Object)e.getKey(), (Object)e.getValue());
        }
        commandParams.add((Object)"path", (Object)archive.getAbsolutePath());
        inv.parameters(commandParams).execute();
        switch (actionReport.getActionExitCode()) {
            case FAILURE: {
                throw new RuntimeException(actionReport.getMessage(), actionReport.getFailureCause());
            }
            case SUCCESS: {
                String name = params.get("name");
                if (name == null) break;
                return name;
            }
            case WARNING: {
                System.out.println("Warnings: " + actionReport.getMessage());
                String name = params.get("name");
                if (name == null) break;
                return name;
            }
        }
        return null;
    }

    private ActionReport createActionReport() {
        return (ActionReport)this.habitat.getComponent(ActionReport.class, "plain");
    }

    public String deploy(URI archive) {
        return null;
    }

    public void undeploy(String appName) {
        this.undeploy(appName, new HashMap<String, String>());
    }

    public void undeploy(String appName, Map<String, String> params) {
        ActionReport actionReport = this.createActionReport();
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("undeploy", actionReport);
        ParameterMap commandParams = new ParameterMap();
        for (Map.Entry<String, String> e : params.entrySet()) {
            commandParams.add((Object)e.getKey(), (Object)e.getValue());
        }
        commandParams.add((Object)"name", (Object)appName);
        inv.parameters(commandParams).execute();
        switch (actionReport.getActionExitCode()) {
            case FAILURE: {
                throw new RuntimeException(actionReport.getMessage(), actionReport.getFailureCause());
            }
        }
        System.out.println(actionReport.getMessage());
    }
}

