/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.Strings;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="MonitoringReporter")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
public class MonitoringReporter
extends V2DottedNameSupport {
    List<Server> targets = new ArrayList<Server>();
    private ActionReport report;
    private AdminCommandContext context;
    private String pattern;
    private String userarg;
    @Inject(optional=true)
    private MonitoringRuntimeDataRegistry datareg;
    @Inject
    private Domain domain;
    @Inject
    private Target targetService;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    Habitat habitat;
    private OutputType outputType;
    private static final String DOTTED_NAME = ".dotted-name";
    private static final String SERVERDOT = "server.";

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nPattern=[").append(this.pattern).append("]").append('\n');
        if (!this.targets.isEmpty()) {
            for (Server server : this.targets) {
                if (server == null) continue;
                sb.append("Server=[").append(server.getName()).append("]").append('\n');
            }
        } else {
            sb.append("No Targets");
        }
        return sb.toString();
    }

    public void prepareGet(AdminCommandContext c, String arg) {
        this.prepare(c, arg, OutputType.GET);
    }

    public void prepareList(AdminCommandContext c, String arg) {
        this.prepare(c, arg, OutputType.LIST);
    }

    public void execute() {
        if (this.hasError()) {
            return;
        }
        this.runLocally();
        this.runRemotely();
    }

    private void prepare(AdminCommandContext c, String arg, OutputType type) {
        this.outputType = type;
        this.context = c;
        this.report = this.context.getActionReport();
        if (this.isDas()) {
            this.prepareDas(arg);
        } else {
            this.prepareInstance(arg);
        }
    }

    private void prepareDas(String arg) {
        try {
            this.setSuccess();
            this.userarg = arg;
            if (!this.validate()) {
                return;
            }
        }
        catch (Exception e) {
            this.setError(Strings.get("admin.get.monitoring.unknown", e.getMessage()));
            this.report.setFailureCause((Throwable)e);
        }
    }

    private void prepareInstance(String arg) {
        this.pattern = arg;
    }

    private void runLocally() {
        TreeNode parent;
        TreeNode tn;
        if (this.isDas() && !this.dasIsInList()) {
            return;
        }
        String localPattern = this.prependServerDot(this.pattern);
        if (!this.isDas()) {
            localPattern = this.serverEnv.getInstanceName() + "." + localPattern;
        }
        if ((tn = this.datareg.get(this.serverEnv.getInstanceName())) == null) {
            this.setSuccess(Strings.get("admin.get.monitoring.empty"));
            return;
        }
        ArrayList<TreeNode> ltn = tn.getNodes(localPattern);
        boolean singleStat = false;
        if ((ltn == null || ltn.isEmpty()) && (parent = tn.getPossibleParentNode(localPattern)) != null) {
            ltn = new ArrayList<TreeNode>(1);
            ltn.add(parent);
            singleStat = true;
        }
        if (!singleStat) {
            localPattern = null;
        }
        if (this.outputType == OutputType.GET) {
            this.doGet(localPattern, ltn);
        } else if (this.outputType == OutputType.LIST) {
            this.doList(localPattern, ltn);
        }
    }

    private void doGet(String localPattern, List<TreeNode> ltn) {
        TreeMap map = new TreeMap();
        for (TreeNode tn1 : this.sortTreeNodesByCompletePathName(ltn)) {
            if (tn1.hasChildNodes()) continue;
            this.insertNameValuePairs(map, tn1, localPattern);
        }
        for (Object obj : map.keySet()) {
            String s = obj.toString();
            ActionReport.MessagePart part = this.report.getTopMessagePart().addChild();
            part.setMessage(s.replace("___SLASH___", "/") + " = " + map.get(obj));
        }
        this.setSuccess();
    }

    private void doList(String localPattern, List<TreeNode> ltn) {
        for (TreeNode tn1 : ltn) {
            if (!tn1.hasChildNodes()) continue;
            ActionReport.MessagePart part = this.report.getTopMessagePart().addChild();
            part.setMessage(tn1.getCompletePathName());
        }
        this.setSuccess();
    }

    private void runRemotely() {
        if (!this.isDas()) {
            return;
        }
        List<Server> remoteServers = this.getRemoteServers();
        if (remoteServers.isEmpty()) {
            return;
        }
        try {
            ParameterMap paramMap = new ParameterMap();
            paramMap.set((Object)"monitor", (Object)"true");
            paramMap.set((Object)"DEFAULT", (Object)this.pattern);
            ClusterOperationUtil.replicateCommand((String)"get", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, remoteServers, (AdminCommandContext)this.context, (ParameterMap)paramMap, (Habitat)this.habitat);
        }
        catch (Exception ex) {
            this.setError(Strings.get("admin.get.monitoring.remote.error", this.getNames(remoteServers)));
        }
    }

    private String prependServerDot(String s) {
        if (s.startsWith(SERVERDOT)) {
            return s;
        }
        return SERVERDOT + s;
    }

    private boolean validate() {
        if (this.datareg == null) {
            this.setError(Strings.get("admin.get.no.monitoring"));
            return false;
        }
        return this.initPatternAndTargets();
    }

    private boolean initPatternAndTargets() {
        String targetName;
        Server das = this.domain.getServerNamed("server");
        List allServers = this.targetService.getAllInstances();
        allServers.add(das);
        if (!StringUtils.ok((String)this.userarg) || this.userarg.equals("*") || this.userarg.equals(".") || this.userarg.equals("*.")) {
            this.targets = allServers;
            this.pattern = "*";
            return true;
        }
        if (this.userarg.startsWith("*.")) {
            this.targets = allServers;
            this.pattern = this.userarg.substring(2);
            if (this.pattern.startsWith(".")) {
                String specificError = Strings.get("admin.get.monitoring.nodoubledot");
                this.setError(Strings.get("admin.get.monitoring.invalidpattern", specificError));
                return false;
            }
            return true;
        }
        if (this.userarg.startsWith("*")) {
            this.targets = allServers;
            this.pattern = this.userarg.substring(1);
            return true;
        }
        int index = this.userarg.indexOf(".");
        if (index >= 0) {
            targetName = this.userarg.substring(0, index);
            this.pattern = this.userarg.length() == index + 1 ? "*" : this.userarg.substring(index + 1);
        } else {
            targetName = this.userarg;
            this.pattern = "*";
        }
        if (targetName.equals("server") || targetName.equals("server-config")) {
            this.targets.add(das);
            return true;
        }
        this.targets = this.targetService.getInstances(targetName);
        if (this.targets.isEmpty()) {
            this.setError(Strings.get("admin.get.monitoring.invalidtarget", this.userarg));
            return false;
        }
        return true;
    }

    private void insertNameValuePairs(TreeMap map, TreeNode tn1, String exactMatch) {
        String name = tn1.getCompletePathName();
        Object value = tn1.getValue();
        if (tn1.getParent() != null) {
            map.put(tn1.getParent().getCompletePathName() + DOTTED_NAME, tn1.getParent().getCompletePathName());
        }
        if (value instanceof Stats) {
            for (Statistic s : ((Stats)value).getStatistics()) {
                String statisticName = s.getName();
                if (statisticName != null) {
                    statisticName = s.getName().toLowerCase();
                }
                this.addStatisticInfo(s, name + "." + statisticName, map);
            }
        } else if (value instanceof Statistic) {
            this.addStatisticInfo(value, name, map);
        } else {
            map.put(name, value);
        }
        if (exactMatch != null) {
            Object val = map.get(exactMatch);
            map.clear();
            if (val != null) {
                map.put(exactMatch, val);
            }
        }
    }

    private void addStatisticInfo(Object value, String name, TreeMap map) {
        Map statsMap = Proxy.isProxyClass(value.getClass()) ? ((StatisticImpl)Proxy.getInvocationHandler(value)).getStaticAsMap() : ((StatisticImpl)value).getStaticAsMap();
        for (String attrName : statsMap.keySet()) {
            Object attrValue = statsMap.get(attrName);
            map.put(name + "-" + attrName, attrValue);
        }
    }

    private void setError(String msg) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.appendMessage(msg);
        this.clear();
    }

    private void setSuccess() {
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void setSuccess(String msg) {
        this.setSuccess();
        this.appendMessage(msg);
    }

    private void appendMessage(String newMessage) {
        String oldMessage = this.report.getMessage();
        if (oldMessage == null) {
            this.report.setMessage(newMessage);
        } else {
            this.report.setMessage(oldMessage + "\n" + newMessage);
        }
    }

    private boolean hasError() {
        return this.report.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    private void clear() {
        this.targets = Collections.emptyList();
        this.pattern = "";
    }

    private List<Server> getRemoteServers() {
        if (!this.isDas()) {
            throw new RuntimeException("Internal Error");
        }
        ArrayList<Server> notdas = new ArrayList<Server>(this.targets.size());
        String dasName = this.serverEnv.getInstanceName();
        for (Server server : this.targets) {
            if (dasName.equals(server.getName())) continue;
            notdas.add(server);
        }
        return notdas;
    }

    private boolean dasIsInList() {
        return this.getRemoteServers().size() != this.targets.size();
    }

    private String getNames(List<Server> list) {
        boolean first = true;
        String ret = "";
        for (Server server : list) {
            if (first) {
                first = false;
            } else {
                ret = ret + ", ";
            }
            ret = ret + server.getName();
        }
        return ret;
    }

    private boolean isDas() {
        return this.serverEnv.isDas();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        GET,
        LIST;

    }
}

