/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.v3.admin.commands.JVMInformation;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="generate-jvm-report")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="generate.jvm.report")
public class GenerateJvmReportCommand
implements AdminCommand {
    @Param(name="target", optional=true)
    String target;
    @Param(name="type", optional=true, defaultValue="summary", acceptableValues="summary, thread, class, memory, log")
    String type;
    private MBeanServer mbs = null;
    private JVMInformation jvmi = null;

    public void execute(AdminCommandContext ctx) {
        this.prepare();
        String result = this.getResult();
        ActionReport report = ctx.getActionReport();
        report.setMessage(result);
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private synchronized void prepare() {
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        if (this.jvmi == null) {
            this.jvmi = new JVMInformation(this.mbs);
        }
    }

    private String getResult() {
        if ("summary".equals(this.type)) {
            return this.jvmi.getSummary(this.target);
        }
        if ("thread".equals(this.type)) {
            return this.jvmi.getThreadDump(this.target);
        }
        if ("class".equals(this.type)) {
            return this.jvmi.getClassInformation(this.target);
        }
        if ("memory".equals(this.type)) {
            return this.jvmi.getMemoryInformation(this.target);
        }
        if ("log".equals(this.type)) {
            return this.jvmi.getLogInformation(this.target);
        }
        throw new IllegalArgumentException("Unsupported Option: " + this.type);
    }
}

