/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.AdminConsoleConfigUpgrade;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.enterprise.v3.admin.adapter.InstallerThread;
import com.sun.enterprise.v3.admin.adapter.Utils;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyOutputBuffer;
import com.sun.grizzly.tcp.http11.GrizzlyOutputStream;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public final class AdminConsoleAdapter
extends GrizzlyAdapter
implements Adapter,
PostConstruct,
EventListener {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    AdminService adminService;
    private String contextRoot;
    private File warFile;
    private AdapterState stateMsg = AdapterState.UNINITIAZED;
    private boolean installing = false;
    private boolean isOK = false;
    private AdminConsoleConfigUpgrade adminConsoleConfigUpgrade = null;
    private final CountDownLatch latch = new CountDownLatch(1);
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;
    @Inject
    volatile AdminService as = null;
    @Inject
    Events events;
    @Inject(name="default-instance-name")
    Config serverConfig;
    AdminEndpointDecider epd;
    private Logger logger = LogDomains.getLogger(AdminConsoleAdapter.class, (String)"javax.enterprise.system.core");
    private String statusHtml;
    private String initHtml = Utils.packageResource2String("downloadgui.html");
    private boolean isRegistered = false;
    private ResourceBundle bundle;
    private static final String MYURL_TOKEN = "%%%MYURL%%%";
    private static final String STATUS_TOKEN = "%%%STATUS%%%";
    private static final String REDIRECT_TOKEN = "%%%LOCATION%%%";
    private static final String RESOURCE_PACKAGE = "com/sun/enterprise/v3/admin/adapter";
    private static final String INSTALL_ROOT = "com.sun.aas.installRoot";
    static final String ADMIN_APP_NAME = "__admingui";
    private boolean isRestStarted = false;
    private boolean isRestBeingStarted = false;

    public AdminConsoleAdapter() throws IOException {
        this.statusHtml = Utils.packageResource2String("status.html");
    }

    public String getContextRoot() {
        return this.epd.getGuiContextRoot();
    }

    public void afterService(GrizzlyRequest req, GrizzlyResponse res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        this.bundle = this.getResourceBundle(req.getLocale());
        if (!this.env.isDas()) {
            this.sendStatusNotDAS(req, res);
            return;
        }
        if (this.adminConsoleConfigUpgrade == null) {
            this.adminConsoleConfigUpgrade = (AdminConsoleConfigUpgrade)this.habitat.getComponent(AdminConsoleConfigUpgrade.class);
        }
        try {
            if (!this.latch.await(100L, TimeUnit.SECONDS)) {
                this.logger.log(Level.SEVERE, "console.adapter.timeout");
                return;
            }
        }
        catch (InterruptedException ex) {
            this.logger.log(Level.SEVERE, "console.adapter.cannotProcess");
            return;
        }
        this.logRequest(req);
        if (this.isResourceRequest(req)) {
            block27: {
                try {
                    this.handleResourceRequest(req, res);
                }
                catch (IOException ioe) {
                    if (this.logger.isLoggable(Level.SEVERE)) {
                        this.logger.log(Level.SEVERE, "console.adapter.resourceError", new Object[]{req.getRequestURI(), ioe.toString()});
                    }
                    if (!this.logger.isLoggable(Level.FINE)) break block27;
                    this.logger.log(Level.FINE, ioe.toString(), ioe);
                }
            }
            return;
        }
        res.setContentType("text/html; charset=UTF-8");
        if ("/testifbackendisready.html".equals(req.getRequestURI())) {
            String status = this.getStateMsg().getI18NKey();
            try {
                status = this.bundle.getString(status);
            }
            catch (MissingResourceException ex) {
                status = this.getStateMsg().toString();
            }
            try {
                GrizzlyOutputBuffer ob = this.getOutputBuffer(res);
                byte[] bytes = (":::" + status).getBytes("UTF-8");
                res.setContentLength(bytes.length);
                ob.write(bytes, 0, bytes.length);
                ob.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(AdminConsoleAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        if (this.isApplicationLoaded()) {
            this.handleLoadedState();
        } else {
            if ("/favicon.ico".equals(req.getRequestURI())) {
                return;
            }
            if (!this.isRestStarted) {
                this.forceRestModuleLoad(req);
            }
            AdminConsoleAdapter adminConsoleAdapter = this;
            synchronized (adminConsoleAdapter) {
                if (this.isInstalling()) {
                    this.sendStatusPage(req, res);
                } else if (this.isApplicationLoaded()) {
                    this.handleLoadedState();
                } else {
                    try {
                        this.setInstalling(true);
                        this.startThread();
                    }
                    catch (Exception ex) {
                        this.setInstalling(false);
                        throw new RuntimeException("Unable to install Admin Console!", ex);
                    }
                    this.sendStatusPage(req, res);
                }
            }
        }
    }

    private boolean isResourceRequest(GrizzlyRequest req) {
        return this.getContentType(req.getRequestURI()) != null;
    }

    private void forceRestModuleLoad(final GrizzlyRequest req) {
        if (this.isRestBeingStarted) {
            return;
        }
        this.isRestBeingStarted = true;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                InputStream is = null;
                try {
                    URL url = new URL("http://localhost:" + req.getLocalPort() + "/management/domain");
                    URLConnection conn = url.openConnection();
                    is = conn.getInputStream();
                    AdminConsoleAdapter.this.isRestStarted = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex1) {
                            Logger.getLogger(AdminConsoleAdapter.class.getName()).log(Level.SEVERE, null, ex1);
                        }
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private String getContentType(String resource) {
        if (resource == null || resource.length() == 0) {
            return null;
        }
        if (resource.endsWith(".gif")) {
            return "image/gif";
        }
        if (resource.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Unhandled content-type: " + resource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResourceRequest(GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        String resourcePath = RESOURCE_PACKAGE + req.getRequestURI();
        ClassLoader loader = AdminConsoleAdapter.class.getClassLoader();
        InputStream in = null;
        try {
            in = loader.getResourceAsStream(resourcePath);
            if (in == null) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "console.adapter.resourceNotFound", resourcePath);
                }
                return;
            }
            byte[] buf = new byte[512];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            int i = in.read(buf);
            while (i != -1) {
                baos.write(buf, 0, i);
                i = in.read(buf);
            }
            String contentType = this.getContentType(resourcePath);
            if (contentType != null) {
                res.setContentType(contentType);
            }
            res.setContentLength(baos.size());
            GrizzlyOutputStream out = res.getOutputStream();
            baos.writeTo((OutputStream)out);
            out.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private boolean isApplicationLoaded() {
        return this.stateMsg == AdapterState.APPLICATION_LOADED;
    }

    boolean isInstalling() {
        return this.installing;
    }

    void setInstalling(boolean flag) {
        this.installing = flag;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    void setStateMsg(AdapterState msg) {
        this.stateMsg = msg;
        this.logger.log(Level.INFO, msg.toString());
    }

    AdapterState getStateMsg() {
        return this.stateMsg;
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.init();
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        this.latch.countDown();
        if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AdminConsoleAdapter is ready.");
        }
    }

    private void init() {
        Property locProp = this.adminService.getProperty("adminConsoleDownloadLocation");
        if (locProp == null || locProp.getValue() == null || locProp.getValue().equals("")) {
            String iRoot = System.getProperty(INSTALL_ROOT) + "/lib/install/applications/admingui.war";
            this.warFile = new File(iRoot.replace('/', File.separatorChar));
            this.writeAdminServiceProp("adminConsoleDownloadLocation", "${com.sun.aas.installRoot}/lib/install/applications/admingui.war");
        } else {
            String locValue = locProp.getValue();
            this.warFile = new File(locValue);
            if (!this.warFile.isAbsolute()) {
                File tmp = new File(System.getProperty(INSTALL_ROOT), "..");
                this.warFile = new File(tmp, locValue);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Admin Console download location: " + this.warFile.getAbsolutePath());
        }
        this.initState();
        this.epd = new AdminEndpointDecider(this.serverConfig, this.logger);
        this.contextRoot = this.epd.getGuiContextRoot();
    }

    private void initState() {
        if (this.appExistsInConfig()) {
            this.isOK = true;
            this.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
        } else if (new File(this.warFile.getParentFile(), ADMIN_APP_NAME).exists() || this.warFile.exists()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.setStateMsg(AdapterState.DOWNLOADED);
            }
            this.isOK = true;
        } else {
            this.setStateMsg(AdapterState.APPLICATION_NOT_INSTALLED);
        }
    }

    private boolean appExistsInConfig() {
        return this.getConfig() != null;
    }

    Application getConfig() {
        Application app = this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), ADMIN_APP_NAME);
        return app;
    }

    private void logRequest(GrizzlyRequest req) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("AdminConsoleAdapter's STATE IS: " + (Object)((Object)this.getStateMsg()));
            this.logger.log(Level.FINE, "Current Thread: " + Thread.currentThread().getName());
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String values = Arrays.toString(req.getParameterValues(name));
                this.logger.fine("Parameter name: " + name + " values: " + values);
            }
        }
    }

    private boolean hasPermission(InteractionResult ir) {
        if (ir == InteractionResult.OK) {
            this.isOK = true;
        }
        return this.isOK;
    }

    private void startThread() {
        new InstallerThread(this, this.habitat, this.domain, this.env, this.contextRoot, this.logger, this.epd.getGuiHosts()).start();
    }

    private GrizzlyOutputBuffer getOutputBuffer(GrizzlyResponse res) {
        GrizzlyOutputBuffer ob = res.getOutputBuffer();
        res.setStatus(202);
        res.setContentType("text/html");
        ob.setEncoding("UTF-8");
        return ob;
    }

    private synchronized void sendConsentPage(GrizzlyRequest req, GrizzlyResponse res) {
        this.setStateMsg(AdapterState.PERMISSION_NEEDED);
        try {
            byte[] bytes;
            GrizzlyOutputBuffer ob = this.getOutputBuffer(res);
            try {
                String localHtml = this.replaceTokens(this.initHtml, this.bundle);
                String hp = this.contextRoot.endsWith("/") ? this.contextRoot : this.contextRoot + "/";
                bytes = localHtml.replace(MYURL_TOKEN, hp).getBytes("UTF-8");
            }
            catch (Exception ex) {
                bytes = ("Catastrophe:" + ex.getMessage()).getBytes("UTF-8");
            }
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendStatusPage(GrizzlyRequest req, GrizzlyResponse res) {
        try {
            GrizzlyOutputBuffer ob = this.getOutputBuffer(res);
            String localHtml = this.replaceTokens(this.statusHtml, this.bundle);
            String status = this.getStateMsg().getI18NKey();
            try {
                status = this.bundle.getString(status);
            }
            catch (MissingResourceException ex) {
                status = this.getStateMsg().toString();
            }
            String locationUrl = req.getScheme() + "://" + req.getServerName() + ':' + req.getServerPort() + "/login.jsf";
            localHtml = localHtml.replace(REDIRECT_TOKEN, locationUrl);
            byte[] bytes = localHtml.replace(STATUS_TOKEN, status).getBytes("UTF-8");
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendStatusNotDAS(GrizzlyRequest req, GrizzlyResponse res) {
        try {
            String html = Utils.packageResource2String("statusNotDAS.html");
            GrizzlyOutputBuffer ob = this.getOutputBuffer(res);
            String localHtml = this.replaceTokens(html, this.bundle);
            byte[] bytes = localHtml.getBytes("UTF-8");
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("com.sun.enterprise.v3.admin.adapter.LocalStrings", locale);
    }

    private String replaceTokens(String text, ResourceBundle bundle) {
        int start = 0;
        int end = 0;
        Object key = null;
        Object newString = null;
        StringBuffer buf = new StringBuffer("");
        Enumeration<String> keys = bundle.getKeys();
        while (start != -1) {
            start = text.indexOf("%%%", end);
            if (start == -1) continue;
            buf.append(text.substring(end, start));
            end = text.indexOf("%%%", start += 3);
            if (end != -1) {
                try {
                    buf.append(bundle.getString(text.substring(start, end)));
                }
                catch (MissingResourceException ex) {
                    buf.append("%%%" + text.substring(start, end) + "%%%");
                }
                end += 3;
                continue;
            }
            buf.append("%%%");
            end = start;
        }
        buf.append(text.substring(end));
        return buf.toString();
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    private void writeAdminServiceProp(final String propName, final String propValue) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AdminService>(){

                public Object run(AdminService adminService) throws PropertyVetoException, TransactionFailure {
                    Property newProp = (Property)adminService.createChild(Property.class);
                    adminService.getProperty().add(newProp);
                    newProp.setName(propName);
                    newProp.setValue(propValue);
                    return newProp;
                }
            }, (ConfigBeanProxy)this.adminService);
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "console.adapter.propertyError", propName + ":" + propValue);
        }
    }

    private void handleLoadedState() {
        this.statusHtml = null;
        this.initHtml = null;
    }

    public int getListenPort() {
        return this.epd.getListenPort();
    }

    public InetAddress getListenAddress() {
        return this.epd.getListenAddress();
    }

    public List<String> getVirtualServers() {
        return this.epd.getGuiHosts();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InteractionResult {
        OK,
        CANCEL,
        FIRST_TIMER;

    }
}

