/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class MbeanService
implements Startup {
    @Inject
    private Domain domain;
    @Inject
    private Target tgt;
    @Inject
    private static Habitat habitat;
    @Inject
    private static ServerEnvironment env;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public static MbeanService getInstance() {
        if (habitat == null) {
            return null;
        }
        return (MbeanService)habitat.getComponent(MbeanService.class);
    }

    public String getHost(String instance) throws InstanceNotFoundException {
        Server s = this.domain.getServerNamed(instance);
        if (s == null) {
            throw new InstanceNotFoundException();
        }
        return s.getAdminHost();
    }

    public String getJMXPort(String instance) throws InstanceNotFoundException {
        Server s = this.domain.getServerNamed(instance);
        if (s == null) {
            throw new InstanceNotFoundException();
        }
        return new PropertyResolver(this.domain, instance).getPropertyValue("JMX_SYSTEM_CONNECTOR_PORT");
    }

    public boolean isDas() {
        return this.tgt.isThisDAS();
    }

    public boolean isValidServer(String name) {
        Server s = null;
        try {
            s = this.domain.getServerNamed(name);
        }
        catch (Throwable t) {
            return false;
        }
        return s != null;
    }

    public List<String> getAllInstances() {
        return this.convertList(this.tgt.getAllInstances());
    }

    public List<String> getInstances(String name) {
        return this.convertList(this.tgt.getInstances(name));
    }

    private List<String> convertList(List<Server> servers) {
        ArrayList<String> serverStrings = new ArrayList<String>();
        for (Server svr : servers) {
            serverStrings.add(svr.getName());
        }
        return serverStrings;
    }

    public boolean isInstance(String name) {
        return env.getInstanceName().equals(name);
    }
}

