/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.v3.common.ActionReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="html")
@Scoped(value=PerLookup.class)
public class HTMLActionReporter
extends ActionReporter {
    public void writeReport(OutputStream os) throws IOException {
        PrintWriter writer = new PrintWriter(os);
        writer.print("<html><head/>");
        writer.println("<body><h1>GlassFish " + this.actionDescription + " command report</h1>" + "<br><br>");
        writer.println("Exit Code : " + this.exitCode);
        writer.println("<hr>");
        this.write(2, this.topMessage, writer);
        writer.println("<hr>");
        if (this.exception != null) {
            writer.println("Exception raised during operation : <br>");
            writer.println("<pre>");
            this.exception.printStackTrace(writer);
            writer.println("</pre>");
        }
        if (this.subActions.size() > 0) {
            writer.println("There are " + this.subActions.size() + " sub operations");
        }
        writer.print("</body></html>");
        writer.flush();
    }

    private void write(int level, ActionReport.MessagePart part, PrintWriter writer) {
        String mess = part.getMessage();
        if (mess == null) {
            mess = "";
        }
        if (level > 6) {
            writer.println(mess);
        } else {
            writer.println("<h" + level + ">" + mess + "</h" + level + ">");
        }
        this.write(part.getProps(), writer);
        for (ActionReport.MessagePart child : part.getChildren()) {
            this.write(level + 1, child, writer);
        }
    }

    private void write(Properties props, PrintWriter writer) {
        if (props == null || props.size() == 0) {
            return;
        }
        writer.println("<table border=\"1\">");
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            writer.println("<tr>");
            writer.println("<td>" + entry.getKey() + "</td>");
            writer.println("<td>" + entry.getValue() + "</td>");
            writer.println("</tr>");
        }
        writer.println("</table>");
    }
}

