/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.HTMLActionReporter;
import com.sun.enterprise.v3.server.AppServerStartup;
import com.sun.hk2.component.Holder;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.deployment.monitor.DeploymentLifecycleStatsProvider;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Priority;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Priority(value=8)
@Service(name="ApplicationLoaderService")
public class ApplicationLoaderService
implements Startup,
PreDestroy,
PostConstruct {
    final Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    @Inject
    Deployment deployment;
    @Inject
    Holder<ArchiveFactory> archiveFactory;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Events events;
    @Inject
    protected Applications applications;
    protected SystemApplications systemApplications;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    ServerEnvironment env;
    @Inject
    Habitat habitat;
    private String deploymentTracingEnabled = null;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        ApplicationRef appRef;
        assert (this.env != null);
        try {
            this.logger.fine("satisfy.optionalpkg.dependency");
            InstalledLibrariesResolver.initializeInstalledLibRegistry((String)this.env.getLibPath().getAbsolutePath());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "optionalpkg.error", e);
        }
        DeploymentLifecycleStatsProvider dlsp = new DeploymentLifecycleStatsProvider();
        StatsProviderManager.register((String)"deployment", (PluginPoint)PluginPoint.SERVER, (String)"deployment/lifecycle", (Object)dlsp);
        this.deploymentTracingEnabled = System.getProperty("org.glassfish.deployment.trace");
        Domain domain = (Domain)this.habitat.getComponent(Domain.class);
        this.systemApplications = domain.getSystemApplications();
        List allApplications = this.applications.getApplications();
        List standaloneAdapters = this.applications.getApplicationsWithSnifferType("connector", true);
        for (Application standaloneAdapter : standaloneAdapters) {
            if (!this.deployment.isAppEnabled(standaloneAdapter) && !this.server.isDas()) continue;
            appRef = this.server.getApplicationRef(standaloneAdapter.getName());
            this.processApplication(standaloneAdapter, appRef, this.logger);
        }
        for (Application app : allApplications) {
            if (app.isStandaloneModule() && app.containsSnifferType("connector") || !this.deployment.isAppEnabled(app) && !this.server.isDas()) continue;
            appRef = this.server.getApplicationRef(app.getName());
            this.processApplication(app, appRef, this.logger);
        }
        String defaultParam = this.env.getStartupContext().getArguments().getProperty("default");
        if (defaultParam != null) {
            this.initializeRuntimeDependencies();
            File sourceFile = defaultParam.equals(".") ? new File(System.getProperty("user.dir")) : new File(defaultParam);
            if (sourceFile.exists()) {
                sourceFile = sourceFile.getAbsoluteFile();
                ReadableArchive sourceArchive = null;
                try {
                    ExtendedDeploymentContext depContext;
                    ApplicationInfo appInfo;
                    sourceArchive = ((ArchiveFactory)this.archiveFactory.get()).openArchive(sourceFile);
                    DeployCommandParameters parameters = new DeployCommandParameters(sourceFile);
                    parameters.name = sourceFile.getName();
                    parameters.enabled = Boolean.TRUE;
                    parameters.origin = OpsParams.Origin.deploy;
                    HTMLActionReporter report = new HTMLActionReporter();
                    if (!sourceFile.isDirectory()) {
                        final File tmpFile = File.createTempFile(sourceFile.getName(), "");
                        String path = tmpFile.getAbsolutePath();
                        if (!tmpFile.delete()) {
                            this.logger.log(Level.WARNING, "cannot.delete.temp.file", new Object[]{path});
                        }
                        File tmpDir = new File(path);
                        tmpDir.deleteOnExit();
                        this.events.register(new EventListener(){

                            public void event(EventListener.Event event) {
                                if (event.is(EventTypes.SERVER_SHUTDOWN) && tmpFile.exists()) {
                                    FileUtils.whack((File)tmpFile);
                                }
                            }
                        });
                        if (tmpDir.mkdirs()) {
                            ArchiveHandler handler = this.deployment.getArchiveHandler(sourceArchive);
                            String appName = handler.getDefaultApplicationName(sourceArchive);
                            DeploymentContextImpl dummyContext = new DeploymentContextImpl((ActionReport)report, this.logger, sourceArchive, (OpsParams)parameters, this.env);
                            handler.expand(sourceArchive, ((ArchiveFactory)this.archiveFactory.get()).createArchive(tmpDir), (DeploymentContext)dummyContext);
                            sourceArchive = ((ArchiveFactory)this.archiveFactory.get()).openArchive(tmpDir);
                            this.logger.log(Level.INFO, "source.not.directory", new Object[]{tmpDir.getAbsolutePath()});
                            parameters.name = appName;
                        }
                    }
                    if ((appInfo = this.deployment.deploy(depContext = this.deployment.getBuilder(this.logger, (OpsParams)parameters, (ActionReport)report).source(sourceArchive).build())) == null) {
                        this.logger.log(Level.SEVERE, "cannot.find.applicationinfo", new Object[]{sourceFile.getAbsolutePath()});
                    }
                }
                catch (RuntimeException e) {
                    this.logger.log(Level.SEVERE, "exception.while.deploying", e);
                }
                catch (IOException ioe) {
                    this.logger.log(Level.SEVERE, "ioexception.while.deploying", ioe);
                }
                finally {
                    if (sourceArchive != null) {
                        try {
                            sourceArchive.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
        this.events.send(new EventListener.Event(Deployment.ALL_APPLICATIONS_PROCESSED, null));
    }

    private void initializeRuntimeDependencies() {
        this.habitat.getComponent(PostStartup.class, "ManagedBeanManagerImpl");
        this.habitat.getComponent(PostStartup.class, "ResourceManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processApplication(Application app, ApplicationRef appRef, Logger log) {
        URI uri;
        long operationStartTime = Calendar.getInstance().getTimeInMillis();
        this.initializeRuntimeDependencies();
        String source = app.getLocation();
        String appName = app.getName();
        if (Boolean.valueOf(app.getDeployProperties().getProperty("isLifecycle")).booleanValue()) {
            return;
        }
        try {
            uri = new URI(source);
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, "cannot.determine.location", new Object[]{e.getMessage()});
            return;
        }
        File sourceFile = new File(uri);
        if (sourceFile.exists()) {
            try {
                ReadableArchive archive = null;
                try {
                    DeploymentTracing tracing = null;
                    if (this.deploymentTracingEnabled != null) {
                        tracing = new DeploymentTracing();
                    }
                    DeployCommandParameters deploymentParams = app.getDeployParameters(appRef);
                    deploymentParams.target = this.server.getName();
                    deploymentParams.origin = OpsParams.Origin.load;
                    if (app.containsSnifferType("osgi")) {
                        deploymentParams.type = "osgi";
                    }
                    archive = ((ArchiveFactory)this.archiveFactory.get()).openArchive(sourceFile, deploymentParams);
                    HTMLActionReporter report = new HTMLActionReporter();
                    ExtendedDeploymentContext depContext = this.deployment.getBuilder(this.logger, (OpsParams)deploymentParams, (ActionReport)report).source(archive).build();
                    if (tracing != null) {
                        depContext.addModuleMetaData((Object)tracing);
                    }
                    depContext.getAppProps().putAll((Map<?, ?>)app.getDeployProperties());
                    depContext.setModulePropsMap(app.getModulePropertiesMap());
                    new ApplicationConfigInfo(app).store(depContext.getAppProps());
                    this.deployment.deploy((Collection)this.deployment.getSniffersFromApp(app), depContext);
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        if (tracing != null) {
                            tracing.print(System.out);
                        }
                        this.logger.log(Level.INFO, "loading.application.time", new Object[]{appName, Calendar.getInstance().getTimeInMillis() - operationStartTime});
                    } else {
                        this.logger.severe(report.getMessage());
                    }
                }
                finally {
                    if (archive != null) {
                        try {
                            archive.close();
                        }
                        catch (IOException e) {
                            this.logger.log(Level.FINE, e.getMessage(), e);
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "exception.open.artifact", e);
            }
        } else {
            this.logger.log(Level.SEVERE, "not.found.in.original.location", new Object[]{source});
        }
    }

    public String toString() {
        return "Application Loader";
    }

    public void preDestroy() {
        ArrayList allApplications = new ArrayList();
        allApplications.addAll(this.applications.getApplications());
        allApplications.addAll(this.systemApplications.getApplications());
        for (Application app : allApplications) {
            ApplicationInfo appInfo = this.deployment.get(app.getName());
            this.stopApplication(app, appInfo);
        }
        HashSet allAppNames = new HashSet();
        allAppNames.addAll(this.appRegistry.getAllApplicationNames());
        for (String appName : allAppNames) {
            ApplicationInfo appInfo = this.appRegistry.get(appName);
            this.stopApplication(null, appInfo);
        }
        for (EngineInfo engineInfo : this.containerRegistry.getContainers()) {
            engineInfo.stop(this.logger);
        }
    }

    private void stopApplication(Application app, ApplicationInfo appInfo) {
        HTMLActionReporter dummy = new HTMLActionReporter();
        if (appInfo != null) {
            if (!appInfo.isLoaded() && this.env.isDas()) {
                this.events.send(new EventListener.Event(Deployment.APPLICATION_DISABLED, (Object)appInfo));
            }
            UndeployCommandParameters parameters = new UndeployCommandParameters(appInfo.getName());
            parameters.origin = OpsParams.Origin.unload;
            try {
                this.deployment.disable(parameters, app, appInfo, (ActionReport)dummy, this.logger);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.appRegistry.remove(appInfo.getName());
        }
    }
}

