/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.universal.GFBase64Decoder;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.Privacy;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdminAdapter
extends StaticHttpHandler
implements Adapter,
PostConstruct,
EventListener {
    public static final String VS_NAME = "__asadmin";
    public static final String PREFIX_URI = "/__asadmin";
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(AdminAdapter.class);
    private static final Logger aalogger = LogDomains.getLogger(AdminAdapter.class, (String)"javax.enterprise.system.tools.admin");
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final GFBase64Decoder decoder = new GFBase64Decoder();
    private static final String BASIC = "Basic ";
    private static final String QUERY_STRING_SEPARATOR = "&";
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";
    private static final String[] authRelatedHeaderNames = new String[]{"X-GlassFish-admin", "X-GlassFish-authToken"};
    private static final String DAS_LOOK_FOR_CERT_PROPERTY_NAME = "org.glassfish.admin.DASCheckAdminCert";
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    CommandRunnerImpl commandRunner;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Events events;
    @Inject(name="default-instance-name")
    Config config;
    private AdminEndpointDecider epd = null;
    @Inject
    ServerContext sc;
    @Inject
    Habitat habitat;
    @Inject
    volatile AdminService as = null;
    @Inject
    volatile Domain domain;
    @Inject(name="default-instance-name")
    private volatile Server server;
    private SecureAdmin secureAdmin;
    final Class<? extends Privacy> privacyClass;
    private boolean isRegistered = false;
    CountDownLatch latch = new CountDownLatch(1);

    protected AdminAdapter(Class<? extends Privacy> privacyClass) {
        super((Set)null);
        this.privacyClass = privacyClass;
    }

    public final HttpHandler getHttpService() {
        return this;
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.epd = new AdminEndpointDecider(this.config, aalogger);
        this.addDocRoot((String)this.env.getProps().get("com.sun.aas.instanceRoot") + "/asadmindocroot/");
        this.secureAdmin = (SecureAdmin)this.habitat.getComponent(SecureAdmin.class);
    }

    public void onMissingResource(Request req, Response res) {
        LogHelper.getDefaultLogger().log(Level.FINER, "Received something on {0}", req.getRequestURI());
        LogHelper.getDefaultLogger().log(Level.FINER, "QueryString = {0}", req.getQueryString());
        String requestURI = req.getRequestURI();
        ActionReport report = this.getClientActionReport(requestURI, req);
        if (requestURI.indexOf(46) != -1) {
            requestURI = requestURI.substring(0, requestURI.indexOf(46));
        }
        PayloadImpl.Outbound outboundPayload = PayloadImpl.Outbound.newInstance();
        try {
            if (!this.latch.await(20L, TimeUnit.SECONDS)) {
                report = this.getClientActionReport(req.getRequestURI(), req);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("V3 cannot process this command at this time, please wait");
            } else {
                if (!this.authenticate(req, report, res)) {
                    return;
                }
                report = this.doCommand(requestURI, req, report, (Payload.Outbound)outboundPayload);
            }
        }
        catch (InterruptedException e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("V3 cannot process this command at this time, please wait");
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Exception while processing command: " + e);
        }
        try {
            res.setStatus(200);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            report.writeReport((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            Properties reportProps = new Properties();
            reportProps.setProperty("data-request-type", "report");
            outboundPayload.addPart(0, report.getContentType(), "report", reportProps, (InputStream)bais);
            res.setContentType(outboundPayload.getContentType());
            outboundPayload.writeTo((OutputStream)res.getOutputStream());
            res.getOutputStream().flush();
            res.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AdminAccessController.Access authenticate(Request req) throws Exception {
        String[] up = AdminAdapter.getUserPassword(req);
        String user = up[0];
        String password = up.length > 1 ? up[1] : "";
        AdminAccessController authenticator = (AdminAccessController)this.habitat.getByContract(AdminAccessController.class);
        if (authenticator != null) {
            Principal sslPrincipal = !this.env.isDas() || Boolean.getBoolean(DAS_LOOK_FOR_CERT_PROPERTY_NAME) ? req.getUserPrincipal() : null;
            return authenticator.loginAsAdmin(user, password, this.as.getAuthRealmName(), req.getRemoteHost(), this.authRelatedHeaders(req), sslPrincipal);
        }
        return AdminAccessController.Access.FULL;
    }

    private Map<String, String> authRelatedHeaders(Request gr) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String authRelatedHeaderName : authRelatedHeaderNames) {
            String value = gr.getHeader(authRelatedHeaderName);
            if (value == null) continue;
            result.put(authRelatedHeaderName, value);
        }
        return result;
    }

    public static String[] getUserPassword(Request req) throws IOException {
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            return new String[]{"", ""};
        }
        String enc = authHeader.substring(BASIC.length());
        String dec = new String(decoder.decodeBuffer(enc));
        int i = dec.indexOf(58);
        if (i < 0) {
            return new String[]{"", ""};
        }
        return new String[]{dec.substring(0, i), dec.substring(i + 1)};
    }

    private boolean authenticate(Request req, ActionReport report, Response res) throws Exception {
        AdminAccessController.Access access = this.authenticate(req);
        switch (access) {
            case FULL: {
                return true;
            }
            case MONITORING: {
                this.reportAuthFailure(res, report, "adapter.auth.remoteReqSecAdminOff", "Remote configuration is currently disabled", 403);
                break;
            }
            case NONE: {
                if (this.env.isDas()) {
                    this.reportAuthFailure(res, report, "adapter.auth.userpassword", "Invalid user name or password", 401, "WWW-Authenticate", "BASIC");
                    break;
                }
                this.reportAuthFailure(res, report, "adapter.auth.notOnInstance", "Configuration access to an instance is not allowed; please connect to the domain admin server instead to make configuration changes", 403);
                break;
            }
            default: {
                String msg = adminStrings.getLocalString("admin.adapter.unkAuth", "Unknown admin access {0} returned; expected one of {1}", new Object[]{access.name(), AdminAccessController.Access.values()});
                throw new IllegalStateException(msg);
            }
        }
        return access == AdminAccessController.Access.FULL;
    }

    private void reportAuthFailure(Response res, ActionReport report, String msgKey, String msg, int httpStatus) throws IOException {
        this.reportAuthFailure(res, report, msgKey, msg, httpStatus, null, null);
    }

    private void reportAuthFailure(Response res, ActionReport report, String msgKey, String msg, int httpStatus, String headerName, String headerValue) throws IOException {
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setMessage(adminStrings.getLocalString(msgKey, msg));
        report.setActionDescription("Authentication error");
        res.setStatus(httpStatus);
        if (headerName != null) {
            res.setHeader(headerName, headerValue);
        }
        res.setContentType(report.getContentType());
        report.writeReport((OutputStream)res.getOutputStream());
        res.getOutputStream().flush();
        res.finish();
    }

    private ActionReport getClientActionReport(String requestURI, Request req) {
        ActionReport report = null;
        if (requestURI.indexOf(46) != -1) {
            String qualifier = requestURI.substring(requestURI.indexOf(46) + 1);
            report = (ActionReport)this.habitat.getComponent(ActionReport.class, qualifier);
        } else {
            String accept;
            String userAgent = req.getHeader("User-Agent");
            if (userAgent != null) {
                report = (ActionReport)this.habitat.getComponent(ActionReport.class, userAgent.substring(userAgent.indexOf(47) + 1));
            }
            if (report == null && (accept = req.getHeader("Accept")) != null) {
                StringTokenizer st = new StringTokenizer(accept, ",");
                while (report == null && st.hasMoreElements()) {
                    String scheme = st.nextToken();
                    report = (ActionReport)this.habitat.getComponent(ActionReport.class, scheme.substring(scheme.indexOf(47) + 1));
                }
            }
        }
        if (report == null) {
            report = (ActionReport)this.habitat.getComponent(ActionReport.class, "html");
        }
        return report;
    }

    protected abstract boolean validatePrivacy(AdminCommand var1);

    private ActionReport doCommand(String requestURI, Request req, ActionReport report, Payload.Outbound outboundPayload) {
        block10: {
            if (!requestURI.startsWith(this.getContextRoot())) {
                String msg = adminStrings.getLocalString("adapter.panic", "Wrong request landed in AdminAdapter {0}", new Object[]{requestURI});
                report.setMessage(msg);
                LogHelper.getDefaultLogger().info(msg);
                return report;
            }
            String command = "";
            if (requestURI.length() > this.getContextRoot().length() + 1) {
                command = requestURI.substring(this.getContextRoot().length() + 1);
            }
            ParameterMap parameters = this.extractParameters(req.getQueryString());
            try {
                AdminCommand adminCommand;
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)req.getContentType(), (InputStream)req.getInputStream(true));
                if (aalogger.isLoggable(Level.FINE)) {
                    aalogger.log(Level.FINE, "***** AdminAdapter {0}  *****", req.getMethod());
                }
                if ((adminCommand = this.commandRunner.getCommand(command, report, aalogger)) == null) {
                    if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
                        return report;
                    }
                    String message = adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{command});
                    aalogger.log(Level.FINE, message);
                    report.setMessage(message);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return report;
                }
                if (this.validatePrivacy(adminCommand)) {
                    CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(command, report);
                    inv.parameters(parameters).inbound((Payload.Inbound)inboundPayload).outbound(outboundPayload).execute();
                    try {
                        CommandRunnerImpl.ExecutionContext inv2 = (CommandRunnerImpl.ExecutionContext)inv;
                        report = inv2.report();
                    }
                    catch (Exception e) {}
                    break block10;
                }
                report.failure(aalogger, adminStrings.getLocalString("adapter.wrongprivacy", "Command {0} does not have {1} visibility", new Object[]{command, this.privacyClass.getSimpleName().toLowerCase(Locale.ENGLISH)}), null);
                return report;
            }
            catch (Throwable t) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(t);
                report.setMessage(t.getLocalizedMessage());
                report.setActionDescription("Last-chance AdminAdapter exception handler");
            }
        }
        return report;
    }

    public void afterService(Request req, Response res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    ParameterMap extractParameters(String requestString) {
        ParameterMap parameters = new ParameterMap();
        StringTokenizer stoken = new StringTokenizer(requestString == null ? "" : requestString, QUERY_STRING_SEPARATOR);
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            if (token.indexOf("=") == -1) continue;
            String paramName = null;
            String value = null;
            paramName = token.substring(0, token.indexOf("="));
            value = token.substring(token.indexOf("=") + 1);
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                aalogger.log(Level.WARNING, adminStrings.getLocalString("adapter.param.decode", "Cannot decode parameter {0} = {1}"));
            }
            if (paramName.startsWith(ASADMIN_CMD_PREFIX) && value != null) {
                try {
                    value = new String(decoder.decodeBuffer(value));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            parameters.add((Object)paramName, (Object)value);
        }
        if (aalogger.isLoggable(Level.FINER)) {
            for (Map.Entry entry : parameters.entrySet()) {
                for (String v : (List)entry.getValue()) {
                    aalogger.log(Level.FINER, "Key {0} = {1}", new Object[]{entry.getKey(), v});
                }
            }
        }
        return parameters;
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.latch.countDown();
            aalogger.fine("Ready to receive administrative commands");
        }
    }

    public int getListenPort() {
        return this.epd.getListenPort();
    }

    public InetAddress getListenAddress() {
        return this.epd.getListenAddress();
    }

    public List<String> getVirtualServers() {
        return this.epd.getAsadminHosts();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }
}

