/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Transport;

public class ConnectionMonitor
implements ConnectionProbe {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;

    public ConnectionMonitor(GrizzlyMonitoring grizzlyMonitoring, String monitoringId, Transport transport) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
    }

    public void onAcceptEvent(Connection connection) {
        Object peerAddress = connection.getPeerAddress();
        if (peerAddress != null) {
            this.grizzlyMonitoring.getConnectionQueueProbeProvider().connectionAcceptedEvent(this.monitoringId, connection.hashCode(), peerAddress.toString());
        }
    }

    public void onConnectEvent(Connection connection) {
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().connectionConnectedEvent(this.monitoringId, connection.hashCode(), connection.getPeerAddress().toString());
    }

    public void onCloseEvent(Connection connection) {
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().connectionClosedEvent(this.monitoringId, connection.hashCode());
    }

    public void onBindEvent(Connection connection) {
    }

    public void onReadEvent(Connection connection, Buffer data, int size) {
    }

    public void onWriteEvent(Connection connection, Buffer data, int size) {
    }

    public void onErrorEvent(Connection connection, Throwable error) {
    }

    public void onIOEventReadyEvent(Connection connection, IOEvent ioEvent) {
    }

    public void onIOEventEnableEvent(Connection connection, IOEvent ioEvent) {
    }

    public void onIOEventDisableEvent(Connection connection, IOEvent ioEvent) {
    }
}

