/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilterForInstance;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="collect-log-files")
@Scoped(value=PerLookup.class)
@I18n(value="collect.log.files")
public class CollectLogFiles
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectLogFiles.class);
    private static final Logger logger = LogDomains.getLogger(CollectLogFiles.class, (String)"javax.enterprise.system.core");
    @Param(optional=true)
    String target = "server";
    @Param
    private String outputFilePath;
    @Inject
    ServerEnvironment env;
    @Inject
    Domain domain;
    @Inject
    private Habitat habitat;
    @Inject
    LoggingConfigImpl loggingConfig;

    public void execute(AdminCommandContext context) {
        boolean created;
        ActionReport report = context.getActionReport();
        Properties props = this.initFileXferProps();
        Server targetServer = this.domain.getServerNamed(this.target);
        File outputFile = new File(this.outputFilePath);
        if (!outputFile.exists() && !(created = outputFile.mkdir())) {
            String errorMsg = localStrings.getLocalString("collectlogfiles.outputPath.notexist", "Output File Path does not exist. Please enter correct value for Outputfilepath.");
            report.setMessage(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (targetServer != null && targetServer.isDas()) {
            String zipFile = "";
            File tempDirectory = null;
            try {
                tempDirectory = File.createTempFile("downloaded", "log");
                tempDirectory.delete();
                tempDirectory.mkdirs();
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files.");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs";
            File targetDir = new File(targetDirPath);
            if (!targetDir.exists()) {
                targetDir.mkdir();
            }
            targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs" + File.separator + targetServer.getName();
            targetDir = new File(targetDirPath);
            targetDir.mkdir();
            this.copyLogFilesForLocalhost(this.env.getDomainRoot() + File.separator + "logs", targetDir.getAbsolutePath(), report, targetServer.getName());
            try {
                zipFile = this.loggingConfig.createZipFile(tempDirectory.getAbsolutePath());
                if (zipFile == null || new File(zipFile) == null) {
                    String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file " + zipFile + ".");
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(errorMsg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            catch (Exception e) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file " + zipFile + ".");
                logger.log(Level.SEVERE, errorMsg, e);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "About to download artifact " + zipFile);
            }
            try {
                File moveZipFile = new File(zipFile);
                outboundPayload.attachFile("application/octet-stream", tempDirectory.toURI().relativize(moveZipFile.toURI()), "files", props, moveZipFile);
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.copyingZip", "Error while copying zip file to " + this.outputFilePath + ".");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            tempDirectory.delete();
        } else if (targetServer != null && targetServer.isInstance()) {
            String instanceName = targetServer.getName();
            String serverNode = targetServer.getNode();
            File tempDirectory = null;
            String zipFile = "";
            try {
                tempDirectory = File.createTempFile("downloaded", "log");
                tempDirectory.delete();
                tempDirectory.mkdirs();
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files.");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                if (serverNode.equals("localhost") || serverNode.equals("127.0.0.1")) {
                    String sourceDir = this.env.getInstanceRoot().getAbsolutePath() + File.separator + ".." + File.separator + ".." + File.separator + "nodes" + File.separator + serverNode + File.separator + instanceName + File.separator + "logs";
                    String targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs";
                    File targetDir = new File(targetDirPath);
                    if (!targetDir.exists()) {
                        targetDir.mkdir();
                    }
                    targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs" + File.separator + instanceName;
                    targetDir = new File(targetDirPath);
                    targetDir.mkdir();
                    this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, instanceName);
                } else {
                    new LogFilterForInstance().downloadAllInstanceLogFiles(this.habitat, targetServer, this.domain, logger, instanceName, tempDirectory.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from " + instanceName + ".");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                zipFile = this.loggingConfig.createZipFile(tempDirectory.getAbsolutePath());
                if (zipFile == null || new File(zipFile) == null) {
                    String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file " + zipFile + ".");
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(errorMsg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file " + zipFile + ".");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "About to download artifact " + zipFile);
            }
            try {
                File moveZipFile = new File(zipFile);
                outboundPayload.attachFile("application/octet-stream", tempDirectory.toURI().relativize(moveZipFile.toURI()), "files", props, moveZipFile);
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.copyingZip", "Error while copying zip file to " + this.outputFilePath + ".");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            tempDirectory.delete();
        } else {
            String finalMessage = "";
            File tempDirectory = null;
            String zipFileName = "";
            try {
                tempDirectory = File.createTempFile("downloaded", "log");
                tempDirectory.delete();
                tempDirectory.mkdirs();
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.creatingTempDirectory", "Error while creating temp directory on server for downloading log files.");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Cluster cluster = this.domain.getClusterNamed(this.target);
            List instances = cluster.getInstances();
            for (Server instance : instances) {
                String instanceName = instance.getName();
                String serverNode = instance.getNode();
                boolean errorOccur = false;
                try {
                    if (serverNode.equals("localhost") || serverNode.equals("127.0.0.1")) {
                        String sourceDir = this.env.getInstanceRoot().getAbsolutePath() + File.separator + ".." + File.separator + ".." + File.separator + "nodes" + File.separator + serverNode + File.separator + instanceName + File.separator + "logs";
                        String targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs";
                        File targetDir = new File(targetDirPath);
                        if (!targetDir.exists()) {
                            targetDir.mkdir();
                        }
                        targetDirPath = tempDirectory.getAbsolutePath() + File.separator + "logs" + File.separator + instanceName;
                        targetDir = new File(targetDirPath);
                        targetDir.mkdir();
                        this.copyLogFilesForLocalhost(sourceDir, targetDir.getAbsolutePath(), report, instanceName);
                    } else {
                        new LogFilterForInstance().downloadAllInstanceLogFiles(this.habitat, instance, this.domain, logger, instanceName, tempDirectory.getAbsolutePath());
                    }
                }
                catch (Exception ex) {
                    String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log files from " + instanceName + ".");
                    logger.log(Level.SEVERE, errorMsg, ex);
                    errorOccur = true;
                    finalMessage = finalMessage + errorMsg + "\n";
                }
                if (errorOccur) continue;
                String successMsg = localStrings.getLocalString("collectlogfiles.successInstanceDownloading", "Log files are downloaded for " + instanceName + ".");
                finalMessage = finalMessage + successMsg + "\n";
            }
            report.setMessage(finalMessage);
            try {
                zipFileName = this.loggingConfig.createZipFile(tempDirectory.getAbsolutePath());
                if (zipFileName == null || new File(zipFileName) == null) {
                    String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file " + zipFileName + ".");
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(errorMsg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.creatingZip", "Error while creating zip file " + zipFileName + ".");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            try {
                File zipFile = new File(zipFileName);
                outboundPayload.attachFile("application/octet-stream", tempDirectory.toURI().relativize(zipFile.toURI()), "files", props, zipFile);
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.copyingZip", "Error while copying zip file to " + this.outputFilePath + ".");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            tempDirectory.delete();
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void copyLogFilesForLocalhost(String sourceDir, String targetDir, ActionReport report, String instanceName) {
        File[] allLogFileNames;
        File logsDir = new File(sourceDir);
        for (File logFile : allLogFileNames = logsDir.listFiles()) {
            File toFile = new File(targetDir, logFile.getName());
            FileInputStream from = null;
            FileOutputStream to = null;
            try {
                int bytesRead;
                from = new FileInputStream(logFile);
                to = new FileOutputStream(toFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytesRead);
                }
            }
            catch (Exception ex) {
                String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log file from " + instanceName + ".");
                logger.log(Level.SEVERE, errorMsg, ex);
                report.setMessage(errorMsg);
                report.setFailureCause((Throwable)ex);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (toFile.exists()) continue;
            String errorMsg = localStrings.getLocalString("collectlogfiles.errInstanceDownloading", "Error while downloading log file from " + instanceName + ".");
            report.setMessage(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private Properties initFileXferProps() {
        Properties props = new Properties();
        props.setProperty("file-xfer-root", this.outputFilePath.replace("\\", "/"));
        return props;
    }
}

