/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.common.util.logging.LoggingOutputStream;
import com.sun.common.util.logging.LoggingXMLNames;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.EarlyLogger;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.internal.api.Init;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class LogManagerService
implements Init,
PostConstruct,
PreDestroy,
org.glassfish.internal.api.LogManager {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject(optional=true)
    Agent agent = null;
    @Inject
    FileMonitoring fileMonitoring;
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    UnprocessedConfigListener ucl;
    @Inject
    Domain domain;
    final Map<String, Handler> gfHandlers = new HashMap<String, Handler>();
    Logger logger = LogDomains.getLogger(LogManagerService.class, (String)"javax.enterprise.system.core");

    public Map<String, String> getLoggingProperties() throws IOException {
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        Map props = null;
        props = targetServer != null ? (targetServer.isDas() ? this.loggingConfig.getLoggingProperties() : (targetServer.getCluster() != null ? this.loggingConfig.getLoggingProperties(targetServer.getCluster().getName()) : (targetServer.isInstance() ? this.loggingConfig.getLoggingProperties(this.env.getInstanceName()) : this.loggingConfig.getLoggingProperties()))) : this.loggingConfig.getLoggingProperties();
        return props;
    }

    public File getLoggingFile() throws IOException {
        File file = null;
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        if (targetServer != null) {
            if (targetServer.isDas()) {
                file = new File(this.env.getConfigDirPath(), "logging.properties");
            } else if (targetServer.getCluster() != null) {
                String pathForLogging = this.env.getConfigDirPath() + File.separator + targetServer.getCluster().getName() + "-config";
                File dirForLogging = new File(pathForLogging);
                file = new File(dirForLogging, "logging.properties");
                if (!file.exists()) {
                    this.loggingConfig.copyLoggingPropertiesFile(dirForLogging);
                    file = new File(dirForLogging, "logging.properties");
                }
            } else if (targetServer.isInstance()) {
                String pathForLogging = this.env.getConfigDirPath() + File.separator + this.env.getInstanceName() + "-config";
                File dirForLogging = new File(pathForLogging);
                file = new File(dirForLogging, "logging.properties");
                if (!file.exists()) {
                    this.loggingConfig.copyLoggingPropertiesFile(dirForLogging);
                    file = new File(dirForLogging, "logging.properties");
                }
            } else {
                file = new File(this.env.getConfigDirPath(), "logging.properties");
            }
        } else {
            file = new File(this.env.getConfigDirPath(), "logging.properties");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        List catchUp;
        Object formatterClass;
        if (System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        final LogManager logMgr = LogManager.getLogManager();
        File logging = null;
        try {
            logging = this.getLoggingFile();
            System.setProperty("java.util.logging.config.file", logging.getAbsolutePath());
            if (!logging.exists()) {
                Logger.getAnonymousLogger().log(Level.WARNING, logging.getAbsolutePath() + " not found, creating new file from template.");
                String rootFolder = (String)this.env.getProps().get("com.sun.aas.installRoot");
                String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
                File src = new File(templateDir, "logging.properties");
                File dest = new File(this.env.getConfigDirPath(), "logging.properties");
                FileUtils.copy((File)src, (File)dest);
                logging = new File(this.env.getConfigDirPath(), "logging.properties");
            }
            logMgr.readConfiguration();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Cannot read logging configuration file : ", e);
        }
        AgentFormatterDelegate agentDelegate = null;
        if (this.agent != null) {
            agentDelegate = new AgentFormatterDelegate(this.agent);
        }
        String formatterClassname = null;
        try {
            Map<String, String> props = this.getLoggingProperties();
            formatterClassname = props.get("java.util.logging.ConsoleHandler.formatter");
            formatterClass = LogManagerService.class.getClassLoader().loadClass(formatterClassname);
            UniformLogFormatter formatter = (UniformLogFormatter)((Class)formatterClass).newInstance();
            for (Handler handler : logMgr.getLogger("").getHandlers()) {
                handler.setFormatter(formatter);
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "logging.read.error", ex);
        }
        catch (ClassNotFoundException exc) {
            this.logger.log(Level.WARNING, "logging.formatter.load ", formatterClassname);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "logging.set.formatter ", e);
        }
        Collection handlers = this.habitat.getAllByContract(Handler.class);
        if (handlers != null && handlers.size() > 0) {
            formatterClass = logMgr;
            synchronized (formatterClass) {
                Enumeration<String> loggerNames = logMgr.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    String loggerName = loggerNames.nextElement();
                    logMgr.getLogger(loggerName);
                    for (Handler handler : this.logger.getHandlers()) {
                        if (!(handler.getFormatter() instanceof UniformLogFormatter)) continue;
                        ((UniformLogFormatter)handler.getFormatter()).setDelegate(agentDelegate);
                    }
                }
                for (Handler handler : handlers) {
                    this.addHandler(handler);
                }
            }
        }
        try {
            Map<String, String> map = this.getLoggingProperties();
            String filterClassName = map.get(LoggingXMLNames.xmltoPropsMap.get("log-filter"));
            if (filterClassName != null) {
                Filter filterClass = (Filter)this.habitat.getComponent(Filter.class, filterClassName);
                Logger rootLogger = Logger.global.getParent();
                if (rootLogger != null) {
                    rootLogger.setFilter(filterClass);
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        Logger anonymousLogger = Logger.getAnonymousLogger();
        LoggingOutputStream los = new LoggingOutputStream(anonymousLogger, Level.INFO);
        PrintStream pout = new PrintStream((OutputStream)los, true);
        System.setOut(pout);
        los = new LoggingOutputStream(anonymousLogger, Level.SEVERE);
        PrintStream perr = new PrintStream((OutputStream)los, true);
        System.setErr(perr);
        if (logging != null) {
            this.fileMonitoring.monitors(logging, new FileMonitoring.FileChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void changed(File changedFile) {
                    Map<String, Handler> map = LogManagerService.this.gfHandlers;
                    synchronized (map) {
                        try {
                            Map<String, String> props = LogManagerService.this.getLoggingProperties();
                            if (props == null) {
                                return;
                            }
                            Set<String> keys = props.keySet();
                            for (String a : keys) {
                                if (a.endsWith(".level")) {
                                    String n = a.substring(0, a.lastIndexOf(".level"));
                                    Level l = Level.parse(props.get(a));
                                    if (logMgr.getLogger(n) != null) {
                                        logMgr.getLogger(n).setLevel(l);
                                        continue;
                                    }
                                    if (LogManagerService.this.gfHandlers.containsKey(n)) {
                                        Handler h = LogManagerService.this.gfHandlers.get(n);
                                        h.setLevel(l);
                                        continue;
                                    }
                                    if (!n.equals("java.util.logging.ConsoleHandler")) continue;
                                    Logger logger = Logger.global.getParent();
                                    Handler[] h = logger.getHandlers();
                                    for (int i = 0; i < h.length; ++i) {
                                        String name = h[i].toString();
                                        if (!name.contains("java.util.logging.ConsoleHandler")) continue;
                                        h[i].setLevel(l);
                                    }
                                    continue;
                                }
                                if (!a.endsWith(".file") || a.contains("${com.sun.aas.instanceRoot}/logs/server.log")) continue;
                                PropertyChangeEvent pce = new PropertyChangeEvent(this, a, "${com.sun.aas.instanceRoot}/logs/server.log", props.get(a));
                                UnprocessedChangeEvents ucel = new UnprocessedChangeEvents(new UnprocessedChangeEvent(pce, "server log filename changed."));
                                ArrayList<UnprocessedChangeEvents> b = new ArrayList<UnprocessedChangeEvents>();
                                b.add(ucel);
                                LogManagerService.this.ucl.unprocessedTransactedEvents(b);
                            }
                            LogManagerService.this.logger.log(Level.INFO, "logging.update.levels");
                        }
                        catch (IOException e) {
                            LogManagerService.this.logger.log(Level.SEVERE, "logging.read.error", e);
                        }
                    }
                }

                public void deleted(File deletedFile) {
                    LogManagerService.this.logger.log(Level.INFO, "logging.properties file removed, updating log levels disabled");
                }
            });
        }
        if (!(catchUp = EarlyLogger.getEarlyMessages()).isEmpty()) {
            for (EarlyLogger.LevelAndMessage levelAndMessage : catchUp) {
                this.logger.log(levelAndMessage.level, levelAndMessage.msg);
            }
            catchUp.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler) {
        Logger rootLogger = Logger.global.getParent();
        if (rootLogger != null) {
            Map<String, Handler> map = this.gfHandlers;
            synchronized (map) {
                rootLogger.addHandler(handler);
                String handlerName = handler.toString();
                this.gfHandlers.put(handlerName.substring(0, handlerName.indexOf("@")), handler);
            }
        }
    }

    public void preDestroy() {
        try {
            for (Inhabitant i : this.habitat.getInhabitants(Handler.class)) {
                i.release();
            }
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }
}

