/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityContainer;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContextException;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SecurityDeployer
extends SimpleDeployer<SecurityContainer, DummyApplication>
implements PostConstruct {
    private static final Logger _logger = LogDomains.getLogger(SecurityDeployer.class, (String)"javax.enterprise.system.core.security");
    @Inject
    private ServerContext serverContext;
    @Inject
    private Habitat habitat;
    @Inject
    private PolicyLoader policyLoader;
    @Inject
    private WebSecurityManagerFactory wsmf;
    private EventListener listener = null;

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        this.generatePolicy(dc);
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        this.removePolicy(dc);
    }

    public DummyApplication load(SecurityContainer container, DeploymentContext context) {
        return new DummyApplication();
    }

    public void unload(DummyApplication container, DeploymentContext context) {
        OpsParams params = context.getCommandParameters(OpsParams.class);
        this.cleanSecurityContext(params.name());
    }

    protected void generatePolicy(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.deploy) {
            return;
        }
        String appName = params.name();
        try {
            Application app = (Application)dc.getModuleMetaData(Application.class);
            WebBundleDescriptor wbd = null;
            Set webDesc = app.getWebBundleDescriptors();
            if (webDesc == null) {
                return;
            }
            Iterator iter = webDesc.iterator();
            if (!iter.hasNext()) {
                return;
            }
            wbd = (WebBundleDescriptor)iter.next();
            this.wsmf.createManager(wbd, false, this.serverContext);
        }
        catch (Exception se) {
            String msg = "Error in generating security policy for " + appName;
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void removePolicy(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.undeploy) {
            return;
        }
        String appName = params.name();
        boolean managersDestroyed = this.cleanSecurityContext(appName);
        if (!managersDestroyed) {
            try {
                String[] webcontexts = this.wsmf.getContextsForApp(appName, true);
                if (webcontexts != null) {
                    for (int i = 0; i < webcontexts.length; ++i) {
                        if (webcontexts[i] == null) continue;
                        SecurityUtil.removePolicy(webcontexts[i]);
                    }
                }
            }
            catch (IASSecurityException ex) {
                String msg = "Error in removing security policy for " + appName;
                _logger.log(Level.WARNING, msg, ex);
                throw new DeploymentException(msg, (Throwable)ex);
            }
        }
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    private boolean cleanSecurityContext(String appName) {
        boolean cleanUpDone = false;
        ArrayList<WebSecurityManager> managers = this.wsmf.getManagersForApp(appName, true);
        for (int i = 0; managers != null && i < managers.size(); ++i) {
            try {
                managers.get(i).destroy();
                cleanUpDone = true;
                continue;
            }
            catch (PolicyContextException pce) {
                _logger.log(Level.WARNING, "Unable to destroy WebSecurityManager", pce);
            }
        }
        return cleanUpDone;
    }

    public static List<EventTypes> getDeploymentEvents() {
        ArrayList<EventTypes> events = new ArrayList<EventTypes>();
        events.add(Deployment.APPLICATION_PREPARED);
        return events;
    }

    public void postConstruct() {
        this.listener = new AppDeployEventListener();
        Events events = (Events)this.habitat.getByContract(Events.class);
        events.register(this.listener);
    }

    public static class AppDeployEventListener
    implements EventListener {
        public void event(EventListener.Event event) {
            if (Deployment.APPLICATION_PREPARED.equals((Object)event.type())) {
                DeploymentContext dc = (DeploymentContext)event.hook();
                OpsParams params = dc.getCommandParameters(OpsParams.class);
                if (params.origin != OpsParams.Origin.deploy) {
                    return;
                }
                String appName = params.name();
                Application app = (Application)dc.getModuleMetaData(Application.class);
                if (app == null) {
                    return;
                }
                Set webDesc = app.getWebBundleDescriptors();
                Set ejbDesc = app.getEjbBundleDescriptors();
                try {
                    String name;
                    String linkName = null;
                    boolean lastInService = false;
                    for (WebBundleDescriptor wbd : webDesc) {
                        name = SecurityUtil.getContextID(wbd);
                        lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                        linkName = name;
                    }
                    for (EjbBundleDescriptor ejbd : ejbDesc) {
                        name = SecurityUtil.getContextID(ejbd);
                        if (name.equals(linkName)) continue;
                        lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                        linkName = name;
                    }
                    for (WebBundleDescriptor wbd : webDesc) {
                        name = SecurityUtil.getContextID(wbd);
                        SecurityUtil.generatePolicyFile(name);
                    }
                    for (EjbBundleDescriptor ejbd : ejbDesc) {
                        name = SecurityUtil.getContextID(ejbd);
                        SecurityUtil.generatePolicyFile(name);
                    }
                }
                catch (IASSecurityException se) {
                    String msg = "Error in generating security policy for " + appName;
                    throw new DeploymentException(msg, (Throwable)se);
                }
            }
        }
    }
}

