/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.TimingDelta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Timings {
    private static final Timings INSTANCE = new Timings("default");
    private static final Map<String, Timings> sInstances = new HashMap<String, Timings>();
    private final List<String> mCheckpointNames;
    private final List<Long> mCheckpointTimes;
    private final String mName;
    private static final String NEWLINE = System.getProperty("line.separator");

    public static Timings getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timings getInstance(String name) {
        Timings timings = null;
        Map<String, Timings> map = sInstances;
        synchronized (map) {
            timings = sInstances.get(name);
            if (timings == null) {
                timings = Timings.newInstance(name);
                sInstances.put(name, timings);
            }
        }
        return timings;
    }

    public static Timings newInstance(String name) {
        return new Timings(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInstance(String name) {
        Map<String, Timings> map = sInstances;
        synchronized (map) {
            sInstances.remove(name);
        }
    }

    public Timings(String name) {
        this.mName = name;
        this.mCheckpointNames = new ArrayList<String>();
        this.mCheckpointTimes = new ArrayList<Long>();
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String checkpointName, long nanoseconds) {
        List<String> list = this.mCheckpointNames;
        synchronized (list) {
            this.mCheckpointNames.add(checkpointName);
            this.mCheckpointTimes.add(nanoseconds);
        }
    }

    public void add(String checkpointName, TimingDelta delta) {
        this.add(checkpointName, delta.elapsedMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<String> list = this.mCheckpointNames;
        synchronized (list) {
            this.mCheckpointNames.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Timing Log ");
        buf.append(StringUtil.quote(this.getName()));
        buf.append(NEWLINE);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Long> times = new ArrayList<Long>();
        List<String> list = this.mCheckpointNames;
        synchronized (list) {
            names.addAll(this.mCheckpointNames);
            times.addAll(this.mCheckpointTimes);
        }
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            long nanos = (Long)times.get(i);
            buf.append(name);
            buf.append(" = ");
            buf.append(StringUtil.getMillisString(nanos));
            buf.append(NEWLINE);
        }
        return buf.toString();
    }
}

