/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.IllegalMessageIdentifierException;
import com.sun.xml.ws.rx.rm.runtime.sequence.MessageNumberRolloverException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OutboundSequence
extends AbstractSequence {
    private static final Logger LOGGER = Logger.getLogger(OutboundSequence.class);
    private final List<Long> unackedMessageIdentifiers = new LinkedList<Long>();
    private final Map<Long, Object> weakMessageStorage = new WeakHashMap<Long, Object>();
    private final Map<Long, Long> weakIdtoCorrelationIdMap = new WeakHashMap<Long, Long>();

    OutboundSequence(String sequenceId, String securityContextTokenId, long expirationTime) {
        super(sequenceId, securityContextTokenId, expirationTime, 0L);
    }

    @Override
    Collection<Long> getUnackedMessageIdStorage() {
        return this.unackedMessageIdentifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long generateNextMessageId() throws MessageNumberRolloverException, IllegalStateException {
        if (this.getStatus() != Sequence.Status.CREATED) {
            throw new IllegalStateException(LocalizationMessages.WSRM_1136_WRONG_SEQUENCE_STATE_NEXT_MESSAGE_ID_REJECTED(this.getId(), (Object)this.getStatus()));
        }
        try {
            this.messageIdLock.writeLock().lock();
            long nextId = this.getLastMessageId() + 1L;
            if (nextId > Long.MAX_VALUE) {
                throw LOGGER.logSevereException(new MessageNumberRolloverException(this.getId(), nextId));
            }
            this.updateLastMessageId(nextId);
            this.unackedMessageIdentifiers.add(new Long(nextId));
            long l = nextId;
            return l;
        }
        finally {
            this.messageIdLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(long correlationId, long id, Object message) throws UnsupportedOperationException {
        Long idKey;
        try {
            this.messageIdLock.readLock().lock();
            int index = this.unackedMessageIdentifiers.indexOf(id);
            idKey = index >= 0 ? this.unackedMessageIdentifiers.get(index) : new Long(id);
        }
        finally {
            this.messageIdLock.readLock().unlock();
        }
        Long correlationIdKey = new Long(correlationId);
        this.weakIdtoCorrelationIdMap.put(idKey, correlationIdKey);
        this.weakMessageStorage.put(correlationIdKey, message);
    }

    @Override
    public Object retrieveMessage(long correlationId) throws UnsupportedOperationException {
        return this.weakMessageStorage.get(correlationId);
    }

    @Override
    public void acknowledgeMessageId(long messageId) throws IllegalMessageIdentifierException {
        if (!this.unackedMessageIdentifiers.remove(messageId)) {
            throw new IllegalMessageIdentifierException(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessageIds(List<Sequence.AckRange> ranges) throws IllegalMessageIdentifierException {
        try {
            this.messageIdLock.writeLock().lock();
            if (ranges == null || ranges.isEmpty()) {
                return;
            }
            if (ranges.size() > 1) {
                Collections.sort(ranges, new Comparator<Sequence.AckRange>(){

                    @Override
                    public int compare(Sequence.AckRange range1, Sequence.AckRange range2) {
                        if (range1.lower <= range2.lower) {
                            return -1;
                        }
                        return 1;
                    }
                });
            }
            Sequence.AckRange lastAckRange = ranges.get(ranges.size() - 1);
            if (this.getLastMessageId() < lastAckRange.upper) {
                throw new IllegalMessageIdentifierException(lastAckRange.upper);
            }
            if (this.unackedMessageIdentifiers.isEmpty()) {
                return;
            }
            Iterator<Long> unackedIterator = this.unackedMessageIdentifiers.iterator();
            Iterator<Sequence.AckRange> rangeIterator = ranges.iterator();
            Sequence.AckRange currentRange = rangeIterator.next();
            while (unackedIterator.hasNext()) {
                long unackedIndex = unackedIterator.next();
                if (unackedIndex >= currentRange.lower && unackedIndex <= currentRange.upper) {
                    unackedIterator.remove();
                    continue;
                }
                if (rangeIterator.hasNext()) {
                    currentRange = rangeIterator.next();
                    continue;
                }
                break;
            }
        }
        finally {
            this.messageIdLock.writeLock().unlock();
        }
    }
}

