/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.AlgorithmSuiteValue;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmSuite
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.AlgorithmSuite,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private AlgorithmSuiteValue value;
    private HashSet<String> props = new HashSet();
    private boolean populated = false;
    private boolean isValid = true;
    private SecurityPolicyVersion spVersion;

    public AlgorithmSuite() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public AlgorithmSuite(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    @Override
    public Set getAdditionalProps() {
        return this.props;
    }

    public void setAdditionalProps(Set properties) {
    }

    public void setType(AlgorithmSuiteValue value) {
        this.value = value;
        this.populated = true;
    }

    @Override
    public AlgorithmSuiteValue getType() {
        this.populate();
        return this.value;
    }

    @Override
    public String getDigestAlgorithm() {
        this.populate();
        return this.value.getDigAlgorithm();
    }

    @Override
    public String getEncryptionAlgorithm() {
        this.populate();
        return this.value.getEncAlgorithm();
    }

    @Override
    public String getSymmetricKeyAlgorithm() {
        this.populate();
        return this.value.getSymKWAlgorithm();
    }

    @Override
    public String getAsymmetricKeyAlgorithm() {
        this.populate();
        return this.value.getAsymKWAlgorithm();
    }

    @Override
    public String getSignatureKDAlogrithm() {
        this.populate();
        return this.value.getSigKDAlgorithm();
    }

    @Override
    public String getEncryptionKDAlogrithm() {
        this.populate();
        return this.value.getEncKDAlgorithm();
    }

    @Override
    public int getMinSKLAlgorithm() {
        this.populate();
        return this.value.getMinSKLAlgorithm();
    }

    @Override
    public String getSymmetricKeySignatureAlgorithm() {
        return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    }

    @Override
    public String getAsymmetricKeySignatureAlgorithm() {
        return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            if (policy == null) {
                if (Constants.logger.isLoggable(Level.FINE)) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                if (this.value == null) {
                    this.value = AlgorithmSuiteValue.Basic128;
                }
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                AlgorithmSuiteValue av;
                if (this.value == null && (av = PolicyUtil.isValidAlgorithmSuiteValue(assertion, this.spVersion)) != null) {
                    this.value = av;
                    continue;
                }
                if (PolicyUtil.isInclusiveC14N(assertion, this.spVersion)) {
                    this.props.add("InclusiveC14N");
                    continue;
                }
                if (PolicyUtil.isXPath(assertion, this.spVersion)) {
                    this.props.add("XPath");
                    continue;
                }
                if (PolicyUtil.isXPathFilter20(assertion)) {
                    this.props.add("XPathFilter20");
                    continue;
                }
                if (PolicyUtil.isSTRTransform10(assertion, this.spVersion)) {
                    this.props.add("STRTransform10");
                    continue;
                }
                if (PolicyUtil.isInclusiveC14NWithComments(assertion)) {
                    if (PolicyUtil.isInclusiveC14NWithCommentsForTransforms(assertion)) {
                        this.props.add("InclusiveC14NWithCommentsForTransforms");
                    }
                    if (!PolicyUtil.isInclusiveC14NWithCommentsForCm(assertion)) continue;
                    this.props.add("InclusiveC14NWithCommentsForCm");
                    continue;
                }
                if (PolicyUtil.isExclusiveC14NWithComments(assertion)) {
                    if (PolicyUtil.isExclusiveC14NWithCommentsForTransforms(assertion)) {
                        this.props.add("ExclusiveC14NWithCommentsForTransforms");
                    }
                    if (!PolicyUtil.isExclusiveC14NWithCommentsForCm(assertion)) continue;
                    this.props.add("ExclusiveC14NWithCommentsForCm");
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "AlgorithmSuite");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            if (this.value == null) {
                this.value = AlgorithmSuiteValue.Basic128;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public String getComputedKeyAlgorithm() {
        return "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
    }

    @Override
    public int getMaxSymmetricKeyLength() {
        return 256;
    }

    @Override
    public int getMinAsymmetricKeyLength() {
        return 1024;
    }

    @Override
    public int getMaxAsymmetricKeyLength() {
        return 4096;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }
}

