/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.embedded;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.glassfish.api.embedded.EmbeddedContainer;
import org.glassfish.api.embedded.EmbeddedContainerInfo;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class ServerInfo {
    @Inject
    private Habitat habitat;
    final String serverName;
    boolean loggerEnabled;
    boolean verbose;
    File loggerFile;
    EmbeddedFileSystem fileSystem;
    private static final HashMap<String, ServerInfo> servers = new HashMap();
    private Server server = null;

    public ServerInfo(String id) {
        this.serverName = id;
    }

    public ServerInfo setLogger(boolean enabled) {
        this.loggerEnabled = enabled;
        return this;
    }

    public ServerInfo setLogFile(File f) {
        this.loggerFile = f;
        return this;
    }

    public ServerInfo setVerbose(boolean b) {
        this.verbose = b;
        return this;
    }

    public ServerInfo setEmbeddedFileSystem(EmbeddedFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    private ServerInfo setHabitat(Habitat h) {
        this.habitat = h;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerInfo getServerInfo(String id) {
        HashMap<String, ServerInfo> hashMap = servers;
        synchronized (hashMap) {
            if (servers.containsKey(id)) {
                return servers.get(id);
            }
            Habitat h = null;
            ServerInfo info = new ServerInfo(id);
            info.setHabitat(h);
            servers.put(id, info);
            return info;
        }
    }

    public synchronized Server create() {
        boolean loggerEnabled = this.loggerEnabled;
        boolean verbose = this.verbose;
        File loggerFile = this.loggerFile;
        EmbeddedFileSystem fileSystem = this.fileSystem;
        if (this.server == null) {
            this.server = new Server(){
                List<EmbeddedContainer> containers = new ArrayList<EmbeddedContainer>();

                @Override
                public <T extends EmbeddedContainerInfo> T createConfig(Class<T> configType) {
                    return (T)((EmbeddedContainerInfo)ServerInfo.this.habitat.getComponent(configType));
                }

                @Override
                public Port createPort(int portNumber) {
                    Port port = (Port)ServerInfo.this.habitat.getComponent(Port.class);
                    port.bind(portNumber);
                    return port;
                }

                @Override
                public Habitat getHabitat() {
                    return ServerInfo.this.habitat;
                }

                @Override
                public String getName() {
                    return ServerInfo.this.serverName;
                }

                @Override
                public <T extends EmbeddedContainer> T addContainer(EmbeddedContainerInfo<T> info) {
                    T container = info.create(this);
                    if (container != null && this.containers.add((EmbeddedContainer)container)) {
                        return container;
                    }
                    return null;
                }

                @Override
                public void start() {
                    for (EmbeddedContainer container : this.containers) {
                        container.start();
                    }
                }

                @Override
                public Collection<EmbeddedContainer> getContainers() {
                    ArrayList<EmbeddedContainer> copy = new ArrayList<EmbeddedContainer>();
                    copy.addAll(this.containers);
                    return copy;
                }

                @Override
                public void stop() {
                    for (EmbeddedContainer container : this.containers) {
                        container.stop();
                    }
                }
            };
        }
        return this.server;
    }
}

