/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.codegen;

import com.sun.corba.ee.impl.orbutil.codegen.AssignmentStatement;
import com.sun.corba.ee.impl.orbutil.codegen.BreakStatement;
import com.sun.corba.ee.impl.orbutil.codegen.DefinitionStatement;
import com.sun.corba.ee.impl.orbutil.codegen.ExpressionFactory;
import com.sun.corba.ee.impl.orbutil.codegen.IfStatement;
import com.sun.corba.ee.impl.orbutil.codegen.Node;
import com.sun.corba.ee.impl.orbutil.codegen.ReturnStatement;
import com.sun.corba.ee.impl.orbutil.codegen.Statement;
import com.sun.corba.ee.impl.orbutil.codegen.StatementBase;
import com.sun.corba.ee.impl.orbutil.codegen.SwitchStatement;
import com.sun.corba.ee.impl.orbutil.codegen.ThrowStatement;
import com.sun.corba.ee.impl.orbutil.codegen.TryStatement;
import com.sun.corba.ee.impl.orbutil.codegen.Visitor;
import com.sun.corba.ee.impl.orbutil.codegen.WhileStatement;
import com.sun.corba.ee.spi.orbutil.codegen.Expression;
import com.sun.corba.ee.spi.orbutil.codegen.Type;
import com.sun.corba.ee.spi.orbutil.codegen.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockStatement
extends StatementBase {
    private List<Statement> body = new ArrayList<Statement>();
    private ExpressionFactory efactory = new ExpressionFactory(this);
    private Map<String, DefinitionStatement> definitions = new HashMap<String, DefinitionStatement>();

    BlockStatement(Node parent) {
        super(parent);
    }

    public Variable getVar(String ident) {
        Variable result = null;
        DefinitionStatement ds = this.definitions.get(ident);
        if (ds != null) {
            result = ds.var();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.body.isEmpty();
    }

    public List<Statement> body() {
        return this.body;
    }

    public ExpressionFactory exprFactory() {
        return this.efactory;
    }

    public void addBreak() {
        this.body.add(new BreakStatement(this));
    }

    public void addReturn() {
        this.body.add(new ReturnStatement(this));
    }

    public void addReturn(Expression expr) {
        this.body.add(new ReturnStatement(this, expr.copy(this, Expression.class)));
    }

    public IfStatement addIf(Expression cond) {
        IfStatement result = new IfStatement(this, cond.copy(this, Expression.class));
        this.body.add(result);
        return result;
    }

    public TryStatement addTry() {
        TryStatement result = new TryStatement(this);
        this.body.add(result);
        return result;
    }

    public void addThrow(Expression expr) {
        this.body.add(new ThrowStatement(this, expr.copy(this, Expression.class)));
    }

    private void checkSwitchExpressionType(Type type) {
        if (type.size() != 1 || type.equals(Type._boolean())) {
            throw new IllegalArgumentException("A switch expression must have type char, byte, short, or int");
        }
    }

    public SwitchStatement addSwitch(Expression value) {
        this.checkSwitchExpressionType(value.type());
        SwitchStatement result = new SwitchStatement(this, value.copy(this, Expression.class));
        this.body.add(result);
        return result;
    }

    public WhileStatement addWhile(Expression expr) {
        WhileStatement result = new WhileStatement(this, expr.copy(this, Expression.class));
        this.body.add(result);
        return result;
    }

    public void addExpression(Expression expr) {
        this.body.add(expr.copy(this, Expression.class));
    }

    public void addAssign(Expression left, Expression right) {
        this.body.add(new AssignmentStatement(this, left.copy(this, Expression.class), right.copy(this, Expression.class)));
    }

    public Expression addDefinition(Type type, String ident, Expression value) {
        if (this.definitions.containsKey(ident)) {
            throw new IllegalArgumentException("This scope already contains a variable named " + ident);
        }
        Variable var = this.efactory.variable(type, ident);
        DefinitionStatement ds = new DefinitionStatement(this, var, value.copy(this, Expression.class));
        this.body.add(ds);
        this.definitions.put(ident, ds);
        return var;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBlockStatement(this);
    }
}

