/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.codegen;

import com.sun.corba.ee.impl.orbutil.codegen.ExpressionFactory;
import com.sun.corba.ee.impl.orbutil.codegen.Node;
import com.sun.corba.ee.impl.orbutil.codegen.TreeWalker;
import com.sun.corba.ee.impl.orbutil.codegen.TreeWalkerContext;
import com.sun.corba.ee.impl.orbutil.codegen.Visitor;
import com.sun.corba.ee.spi.orbutil.codegen.ImportList;
import com.sun.corba.ee.spi.orbutil.codegen.Type;
import com.sun.corba.ee.spi.orbutil.codegen.Variable;
import java.util.List;

public class SourceExpressionVisitor
extends TreeWalker {
    private ImportList imports;
    private StringBuilder sb;

    private String typeName(Type type) {
        if (this.imports.contains(type)) {
            return type.className();
        }
        return type.name();
    }

    public String value() {
        return this.sb.toString();
    }

    public SourceExpressionVisitor(TreeWalkerContext context, ImportList imports) {
        super(context);
        context.push(this);
        this.imports = imports;
        this.sb = new StringBuilder();
    }

    public boolean preNode(Node arg) {
        return false;
    }

    public boolean preVariable(Variable arg) {
        this.sb.append(arg.ident());
        return false;
    }

    public void postVariable(Variable arg) {
    }

    public boolean preConstantExpression(ExpressionFactory.ConstantExpression arg) {
        Object value = arg.value();
        Type type = arg.type();
        String javaRep = type == Type._null() ? "null" : (type == Type._Class() ? this.typeName((Type)Type.class.cast(value)) + ".class" : (type == Type._String() ? "\"" + value + "\"" : (type == Type._char() ? "'" + value + "'" : value.toString())));
        this.sb.append(javaRep);
        return false;
    }

    public boolean preVoidExpression(ExpressionFactory.VoidExpression arg) {
        this.sb.append("void");
        return false;
    }

    public boolean preThisExpression(ExpressionFactory.ThisExpression arg) {
        this.sb.append("this");
        return false;
    }

    public boolean preUnaryOperatorExpression(ExpressionFactory.UnaryOperatorExpression arg) {
        this.sb.append(arg.operator().javaRepresentation());
        this.sb.append('(');
        return true;
    }

    public void postUnaryOperatorExpression(ExpressionFactory.UnaryOperatorExpression arg) {
        this.sb.append(')');
    }

    public boolean preBinaryOperatorExpression(ExpressionFactory.BinaryOperatorExpression arg) {
        this.sb.append('(');
        return true;
    }

    public void binaryOperatorExpressionBeforeRight(ExpressionFactory.BinaryOperatorExpression arg) {
        this.sb.append(arg.operator().javaRepresentation());
    }

    public void postBinaryOperatorExpression(ExpressionFactory.BinaryOperatorExpression arg) {
        this.sb.append(')');
    }

    public boolean preCastExpression(ExpressionFactory.CastExpression arg) {
        this.sb.append("((");
        this.sb.append(this.typeName(arg.type()));
        this.sb.append(')');
        return true;
    }

    public void postCastExpression(ExpressionFactory.CastExpression arg) {
        this.sb.append(')');
    }

    public boolean preInstofExpression(ExpressionFactory.InstofExpression arg) {
        this.sb.append('(');
        return true;
    }

    public void postInstofExpression(ExpressionFactory.InstofExpression arg) {
        this.sb.append(" instanceof ");
        this.sb.append(this.typeName(arg.type()));
        this.sb.append(')');
    }

    public boolean preNonStaticCallExpression(ExpressionFactory.NonStaticCallExpression arg) {
        this.context.mark();
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    public void nonStaticCallExpressionBeforeArg(ExpressionFactory.NonStaticCallExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    public void postNonStaticCallExpression(ExpressionFactory.NonStaticCallExpression arg) {
        List<Visitor> marks = this.context.popMark();
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr == 0) {
                this.sb.append(sev.value());
                this.sb.append('.');
                this.sb.append(arg.ident());
                this.sb.append('(');
            } else {
                if (ctr > 1) {
                    this.sb.append(", ");
                }
                this.sb.append(sev.value());
            }
            ++ctr;
        }
        this.sb.append(")");
    }

    public boolean preStaticCallExpression(ExpressionFactory.StaticCallExpression arg) {
        this.context.mark();
        return true;
    }

    public void staticCallExpressionBeforeArg(ExpressionFactory.StaticCallExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    public void postStaticCallExpression(ExpressionFactory.StaticCallExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append(this.typeName((Type)arg.target()));
        this.sb.append('.');
        this.sb.append(arg.ident());
        this.sb.append('(');
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    public boolean preNewObjExpression(ExpressionFactory.NewObjExpression arg) {
        this.context.mark();
        return true;
    }

    public void newObjExpressionBeforeArg(ExpressionFactory.NewObjExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    public void postNewObjExpression(ExpressionFactory.NewObjExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append("new ");
        this.sb.append(this.typeName(arg.type()));
        this.sb.append('(');
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    public boolean preNewArrExpression(ExpressionFactory.NewArrExpression arg) {
        this.context.mark();
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    public void newArrExpressionBeforeExpression(ExpressionFactory.NewArrExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    public void postNewArrExpression(ExpressionFactory.NewArrExpression arg) {
        List<Visitor> marks = this.context.popMark();
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr == 0) {
                this.sb.append("new ");
                this.sb.append(this.typeName(arg.ctype()));
                this.sb.append('[');
                if (arg.exprs().size() == 0) {
                    this.sb.append(sev.value());
                    this.sb.append(']');
                } else {
                    this.sb.append("] {");
                }
            } else {
                if (ctr > 1) {
                    this.sb.append(", ");
                }
                this.sb.append(sev.value());
            }
            ++ctr;
        }
        this.sb.append("}");
    }

    public boolean preSuperCallExpression(ExpressionFactory.SuperCallExpression arg) {
        this.context.mark();
        return true;
    }

    public void superCallExpressionBeforeArg(ExpressionFactory.SuperCallExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    public void postSuperCallExpression(ExpressionFactory.SuperCallExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append("super.");
        this.sb.append(arg.ident());
        this.sb.append('(');
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    public boolean preSuperObjExpression(ExpressionFactory.SuperObjExpression arg) {
        this.context.mark();
        return true;
    }

    public void superObjExpressionBeforeArg(ExpressionFactory.SuperObjExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    public void postSuperObjExpression(ExpressionFactory.SuperObjExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append("super(");
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    public boolean preThisObjExpression(ExpressionFactory.ThisObjExpression arg) {
        this.context.mark();
        return true;
    }

    public void thisObjExpressionBeforeArg(ExpressionFactory.ThisObjExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    public void postThisObjExpression(ExpressionFactory.ThisObjExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append("this(");
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    public boolean preNonStaticFieldAccessExpression(ExpressionFactory.NonStaticFieldAccessExpression arg) {
        return true;
    }

    public void postNonStaticFieldAccessExpression(ExpressionFactory.NonStaticFieldAccessExpression arg) {
        this.sb.append('.');
        this.sb.append(arg.fieldName());
    }

    public boolean preStaticFieldAccessExpression(ExpressionFactory.StaticFieldAccessExpression arg) {
        return true;
    }

    public void postStaticFieldAccessExpression(ExpressionFactory.StaticFieldAccessExpression arg) {
        this.sb.append(this.typeName((Type)arg.target()));
        this.sb.append('.');
        this.sb.append(arg.fieldName());
    }

    public boolean preArrayIndexExpression(ExpressionFactory.ArrayIndexExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    public void arrayIndexExpressionBeforeExpr(ExpressionFactory.ArrayIndexExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    public void postArrayIndexExpression(ExpressionFactory.ArrayIndexExpression arg) {
        SourceExpressionVisitor expr = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        SourceExpressionVisitor index = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.sb.append(expr.value());
        this.sb.append('[');
        this.sb.append(index.value());
        this.sb.append(']');
    }

    public boolean preArrayLengthExpression(ExpressionFactory.ArrayLengthExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    public void postArrayLengthExpression(ExpressionFactory.ArrayLengthExpression arg) {
        SourceExpressionVisitor expr = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.sb.append(expr.value());
        this.sb.append(".length");
    }
}

