/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.misc;

import com.sun.corba.ee.spi.orbutil.misc.ObjectWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ObjectUtility {
    private boolean useToString;
    private boolean isIndenting;
    private int initialLevel;
    private int increment;
    private ClassMap classToPrinter = new ClassMap();
    private static ObjectUtility standard = new ObjectUtility(false, true, 0, 4);
    private static ObjectUtility compact = new ObjectUtility(true, false, 0, 4);
    private ObjectPrinter propertiesPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            if (!(obj instanceof Properties)) {
                throw new Error();
            }
            Properties props = (Properties)obj;
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                buff.startElement();
                buff.append(key);
                buff.append("=");
                buff.append(value);
                buff.endElement();
            }
        }
    };
    private ObjectPrinter collectionPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            if (!(obj instanceof Collection)) {
                throw new Error();
            }
            Collection coll = (Collection)obj;
            for (Object element : coll) {
                buff.startElement();
                ObjectUtility.this.objectToStringHelper(printed, buff, element);
                buff.endElement();
            }
        }
    };
    private ObjectPrinter mapPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap printed, ObjectWriter buff, Object obj) {
            if (!(obj instanceof Map)) {
                throw new Error();
            }
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                buff.startElement();
                ObjectUtility.this.objectToStringHelper(printed, buff, entry.getKey());
                buff.append("=>");
                ObjectUtility.this.objectToStringHelper(printed, buff, entry.getValue());
                buff.endElement();
            }
        }
    };

    private ObjectUtility(boolean useToString, boolean isIndenting, int initialLevel, int increment) {
        this.useToString = useToString;
        this.isIndenting = isIndenting;
        this.initialLevel = initialLevel;
        this.increment = increment;
        this.classToPrinter.put(Properties.class, this.propertiesPrinter);
        this.classToPrinter.put(Collection.class, this.collectionPrinter);
        this.classToPrinter.put(Map.class, this.mapPrinter);
    }

    public static ObjectUtility make(boolean useToString, boolean isIndenting, int initialLevel, int increment) {
        return new ObjectUtility(useToString, isIndenting, initialLevel, increment);
    }

    public static ObjectUtility make(boolean useToString, boolean isIndenting) {
        return new ObjectUtility(useToString, isIndenting, 0, 4);
    }

    public static ObjectUtility make() {
        return standard;
    }

    public static String defaultObjectToString(Object object) {
        return standard.objectToString(object);
    }

    public static String compactObjectToString(Object object) {
        return compact.objectToString(object);
    }

    public String objectToString(Object obj) {
        IdentityHashMap printed = new IdentityHashMap();
        ObjectWriter result = ObjectWriter.make(this.isIndenting, this.initialLevel, this.increment);
        this.objectToStringHelper(printed, result, obj);
        return result.toString();
    }

    public static boolean equals(Object obj1, Object obj2) {
        HashSet considered = new HashSet();
        IdentityHashMap counterpart = new IdentityHashMap();
        return ObjectUtility.equalsHelper(counterpart, considered, obj1, obj2);
    }

    public static Object concatenateArrays(Object arr1, Object arr2) {
        int ctr;
        Class<?> comp1 = arr1.getClass().getComponentType();
        Class<?> comp2 = arr2.getClass().getComponentType();
        int len1 = Array.getLength(arr1);
        int len2 = Array.getLength(arr2);
        if (comp1 == null || comp2 == null) {
            throw new IllegalStateException("Arguments must be arrays");
        }
        if (!comp1.equals(comp2)) {
            throw new IllegalStateException("Arguments must be arrays with the same component type");
        }
        Object result = Array.newInstance(comp1, len1 + len2);
        int index = 0;
        for (ctr = 0; ctr < len1; ++ctr) {
            Array.set(result, index++, Array.get(arr1, ctr));
        }
        for (ctr = 0; ctr < len2; ++ctr) {
            Array.set(result, index++, Array.get(arr2, ctr));
        }
        return result;
    }

    private void objectToStringHelper(IdentityHashMap printed, ObjectWriter result, Object obj) {
        if (obj == null) {
            result.append("null");
            result.endElement();
        } else {
            Class<?> cls = obj.getClass();
            result.startObject(obj);
            if (printed.keySet().contains(obj)) {
                result.endObject("*VISITED*");
            } else {
                printed.put(obj, null);
                if (this.mustUseToString(cls)) {
                    result.endObject(obj.toString());
                } else {
                    ObjectPrinter printer = (ObjectPrinter)this.classToPrinter.get(cls);
                    if (printer != null) {
                        printer.print(printed, result, obj);
                        result.endObject();
                    } else {
                        Class<?> compClass = cls.getComponentType();
                        if (compClass == null) {
                            this.handleObject(printed, result, obj);
                        } else {
                            this.handleArray(printed, result, obj);
                            result.endObject();
                        }
                    }
                }
            }
        }
    }

    private boolean mustUseToString(Class cls) {
        if (cls.isPrimitive()) {
            return true;
        }
        if (cls == Integer.class || cls == BigInteger.class || cls == BigDecimal.class || cls == String.class || cls == StringBuffer.class || cls == Long.class || cls == Short.class || cls == Byte.class || cls == Character.class || cls == Float.class || cls == Double.class || cls == Boolean.class) {
            return true;
        }
        if (this.useToString) {
            try {
                cls.getDeclaredMethod("toString", new Class[0]);
                return true;
            }
            catch (Exception exc) {
                return false;
            }
        }
        return false;
    }

    private void checkPackageAccess(Class cls) {
        String cname;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (cname = cls.getName().replace('/', '.')).startsWith("[")) {
            int lastDot;
            int lastBracket = cname.lastIndexOf("[") + 2;
            if (lastBracket > 1 && lastBracket < cname.length()) {
                cname = cname.substring(lastBracket);
            }
            if ((lastDot = cname.lastIndexOf(46)) != -1) {
                String pname = cname.substring(0, lastDot);
                sm.checkPackageAccess(pname);
            }
        }
    }

    private Field[] getDeclaredFields(Class cls) {
        this.checkPackageAccess(cls);
        return cls.getDeclaredFields();
    }

    private void handleObject(IdentityHashMap printed, ObjectWriter result, Object obj) {
        Class<?> cls = obj.getClass();
        try {
            SecurityManager security = System.getSecurityManager();
            Field[] fields = security != null && !Modifier.isPublic(cls.getModifiers()) ? new Field[]{} : this.getDeclaredFields(cls);
            for (int ctr = 0; ctr < fields.length; ++ctr) {
                final Field fld = fields[ctr];
                int modifiers = fld.getModifiers();
                if (Modifier.isStatic(modifiers) || security != null && !Modifier.isPublic(modifiers)) continue;
                result.startElement();
                result.append(fld.getName());
                result.append(":");
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            fld.setAccessible(true);
                            return null;
                        }
                    });
                    Object value = fld.get(obj);
                    this.objectToStringHelper(printed, result, value);
                }
                catch (Exception exc2) {
                    result.append("???");
                }
                result.endElement();
            }
            result.endObject();
        }
        catch (Exception exc2) {
            result.endObject(obj.toString());
        }
    }

    private void handleArray(IdentityHashMap printed, ObjectWriter result, Object obj) {
        Class<?> compClass = obj.getClass().getComponentType();
        if (compClass == Boolean.TYPE) {
            boolean[] arr = (boolean[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Byte.TYPE) {
            byte[] arr = (byte[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Short.TYPE) {
            short[] arr = (short[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Integer.TYPE) {
            int[] arr = (int[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Long.TYPE) {
            long[] arr = (long[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Character.TYPE) {
            char[] arr = (char[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Float.TYPE) {
            float[] arr = (float[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else if (compClass == Double.TYPE) {
            double[] arr = (double[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                result.append(arr[ctr]);
                result.endElement();
            }
        } else {
            Object[] arr = (Object[])obj;
            for (int ctr = 0; ctr < arr.length; ++ctr) {
                result.startElement();
                this.objectToStringHelper(printed, result, arr[ctr]);
                result.endElement();
            }
        }
    }

    private static boolean equalsHelper(Map counterpart, Set considered, Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        Object other2 = counterpart.get(obj1);
        if (other2 == null) {
            other2 = obj2;
            counterpart.put(obj1, other2);
        }
        if (obj1 == other2) {
            return true;
        }
        if (obj2 != other2) {
            return false;
        }
        Pair pair = new Pair(obj1, obj2);
        if (considered.contains(pair)) {
            return true;
        }
        considered.add(pair);
        if (obj1 instanceof Object[] && obj2 instanceof Object[]) {
            return ObjectUtility.equalArrays(counterpart, considered, (Object[])obj1, (Object[])obj2);
        }
        if (obj1 instanceof Map && obj2 instanceof Map) {
            return ObjectUtility.equalMaps(counterpart, considered, (Map)obj1, (Map)obj2);
        }
        if (obj1 instanceof Set && obj2 instanceof Set) {
            return ObjectUtility.equalSets(counterpart, considered, (Set)obj1, (Set)obj2);
        }
        if (obj1 instanceof List && obj2 instanceof List) {
            return ObjectUtility.equalLists(counterpart, considered, (List)obj1, (List)obj2);
        }
        if (obj1 instanceof boolean[] && obj2 instanceof boolean[]) {
            return Arrays.equals((boolean[])obj1, (boolean[])obj2);
        }
        if (obj1 instanceof byte[] && obj2 instanceof byte[]) {
            return Arrays.equals((byte[])obj1, (byte[])obj2);
        }
        if (obj1 instanceof char[] && obj2 instanceof char[]) {
            return Arrays.equals((char[])obj1, (char[])obj2);
        }
        if (obj1 instanceof double[] && obj2 instanceof double[]) {
            return Arrays.equals((double[])obj1, (double[])obj2);
        }
        if (obj1 instanceof float[] && obj2 instanceof float[]) {
            return Arrays.equals((float[])obj1, (float[])obj2);
        }
        if (obj1 instanceof int[] && obj2 instanceof int[]) {
            return Arrays.equals((int[])obj1, (int[])obj2);
        }
        if (obj1 instanceof long[] && obj2 instanceof long[]) {
            return Arrays.equals((long[])obj1, (long[])obj2);
        }
        Class<?> cls = obj1.getClass();
        if (cls != obj2.getClass()) {
            return obj1.equals(obj2);
        }
        return ObjectUtility.equalsObject(counterpart, considered, cls, obj1, obj2);
    }

    private static boolean equalsObject(Map counterpart, Set considered, Class cls, Object obj1, Object obj2) {
        Class<Object> objectClass = Object.class;
        if (cls == objectClass) {
            return true;
        }
        try {
            Method equalsMethod = cls.getDeclaredMethod("equals", objectClass);
            return obj1.equals(obj2);
        }
        catch (Exception exc) {
            if (ObjectUtility.equalsObjectFields(counterpart, considered, cls, obj1, obj2)) {
                return ObjectUtility.equalsObject(counterpart, considered, cls.getSuperclass(), obj1, obj2);
            }
            return false;
        }
    }

    private static boolean equalsObjectFields(Map counterpart, Set considered, Class cls, Object obj1, Object obj2) {
        Field[] fields = cls.getDeclaredFields();
        for (int ctr = 0; ctr < fields.length; ++ctr) {
            try {
                final Field field = fields[ctr];
                if (Modifier.isStatic(field.getModifiers())) continue;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                Object value1 = field.get(obj1);
                Object value2 = field.get(obj2);
                if (ObjectUtility.equalsHelper(counterpart, considered, value1, value2)) continue;
                return false;
            }
            catch (IllegalAccessException exc) {
                return false;
            }
        }
        return true;
    }

    private static boolean equalArrays(Map counterpart, Set considered, Object[] arr1, Object[] arr2) {
        int len = arr1.length;
        if (len != arr2.length) {
            return false;
        }
        for (int ctr = 0; ctr < len; ++ctr) {
            if (ObjectUtility.equalsHelper(counterpart, considered, arr1[ctr], arr2[ctr])) continue;
            return false;
        }
        return true;
    }

    private static boolean equalMaps(Map counterpart, Set considered, Map map1, Map map2) {
        if (map2.size() != map1.size()) {
            return false;
        }
        try {
            for (Map.Entry e : map1.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? map2.get(key) != null || !map2.containsKey(key) : !ObjectUtility.equalsHelper(counterpart, considered, value, map2.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    private static boolean equalSets(Map counterpart, Set considered, Set set1, Set set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        for (Object obj1 : set1) {
            boolean found = false;
            Iterator e2 = set2.iterator();
            while (e2.hasNext() && !found) {
                Object obj2 = e2.next();
                found = ObjectUtility.equals(obj1, obj2);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean equalLists(Map counterpart, Set considered, List list1, List list2) {
        ListIterator e1 = list1.listIterator();
        ListIterator e2 = list2.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? ObjectUtility.equalsHelper(counterpart, considered, o1, o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    private static void sop(String msg) {
        System.out.println(msg);
    }

    public static void displayException(Throwable thr) {
        for (Throwable current = thr; current != null; current = current.getCause()) {
            StackTraceElement[] elems;
            if (current != thr) {
                ObjectUtility.sop("Caused By:");
            }
            if ((elems = thr.getStackTrace()) == null) {
                ObjectUtility.sop("\tNo stack trace available");
                continue;
            }
            for (final StackTraceElement elem : elems) {
                ObjectUtility.sop("\t" + elem);
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                Class<?> cls = Class.forName(elem.getClassName());
                                ClassLoader loader = cls.getClassLoader();
                                ObjectUtility.sop("\t\tClassLoader = " + loader);
                                ProtectionDomain pd = cls.getProtectionDomain();
                                CodeSource cs = pd.getCodeSource();
                                ObjectUtility.sop("\t\tCodeSource contents:");
                                ObjectUtility.sop("\t\t\tLocation = " + cs.getLocation());
                                PermissionCollection pcoll = pd.getPermissions();
                                ObjectUtility.sop("\t\t\tPermissions:");
                                Enumeration<Permission> perms = pcoll.elements();
                                while (perms.hasMoreElements()) {
                                    Permission perm = perms.nextElement();
                                    ObjectUtility.sop("\t\t\t\t" + perm);
                                }
                                Principal[] principals = pd.getPrincipals();
                                ObjectUtility.sop("\t\t\tPrincipals:");
                                for (Principal p : principals) {
                                    ObjectUtility.sop("\t\t\t\t" + p);
                                }
                            }
                            catch (Exception exc) {
                                ObjectUtility.sop("\t\tCould not load class " + elem.getClassName());
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exc) {
                    ObjectUtility.sop("\t\tError: could not get information for stack trace element");
                }
            }
        }
    }

    private static void a() {
        ObjectUtility.b();
    }

    private static void b() {
        ObjectUtility.c();
    }

    private static void c() {
        ObjectUtility.d();
    }

    private static void d() {
        ObjectUtility.e();
    }

    private static void e() {
        throw new RuntimeException();
    }

    public static void main(String[] args) {
        try {
            ObjectUtility.a();
        }
        catch (Exception exc) {
            ObjectUtility.displayException(exc);
        }
    }

    private static class Pair {
        private Object obj1;
        private Object obj2;

        Pair(Object obj1, Object obj2) {
            this.obj1 = obj1;
            this.obj2 = obj2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)obj;
            return other.obj1 == this.obj1 && other.obj2 == this.obj2;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj1) ^ System.identityHashCode(this.obj2);
        }
    }

    private static class ClassMap {
        ArrayList data = new ArrayList();

        public Object get(Class cls) {
            for (Object[] arr : this.data) {
                Class key = (Class)arr[0];
                if (!key.isAssignableFrom(cls)) continue;
                return arr[1];
            }
            return null;
        }

        public void put(Class cls, Object obj) {
            Object[] pair = new Object[]{cls, obj};
            this.data.add(pair);
        }
    }

    private static interface ObjectPrinter {
        public void print(IdentityHashMap var1, ObjectWriter var2, Object var3);
    }
}

