/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.testing;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.ServerTubelineAssemblyContext;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxConfigurationFactory;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.testing.PacketFilter;
import com.sun.xml.ws.rx.testing.PacketFilteringFeature;
import java.io.IOException;
import java.util.List;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PacketFilteringTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(PacketFilteringTube.class);
    private final boolean isClientSide;
    private final List<PacketFilter> filters;

    public PacketFilteringTube(PacketFilteringTube original, TubeCloner cloner) {
        super(original, cloner);
        this.isClientSide = original.isClientSide;
        this.filters = original.filters;
    }

    public PacketFilteringTube(ClientTubelineAssemblyContext context) throws RxRuntimeException {
        super(context.getTubelineHead());
        this.isClientSide = true;
        RxConfiguration configuration = RxConfigurationFactory.INSTANCE.createConfiguration(context.getWsdlPort(), context.getBinding(), null);
        this.filters = this.getConfiguredFilters(context.getBinding(), configuration);
    }

    public PacketFilteringTube(ServerTubelineAssemblyContext context) throws RxRuntimeException {
        super(context.getTubelineHead());
        this.isClientSide = false;
        RxConfiguration configuration = RxConfigurationFactory.INSTANCE.createConfiguration(context.getWsdlPort(), context.getEndpoint().getBinding(), context.getWrappedContext().getEndpoint().getManagedObjectManager());
        this.filters = this.getConfiguredFilters(context.getEndpoint().getBinding(), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketFilteringTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            PacketFilteringTube packetFilteringTube = new PacketFilteringTube(this, cloner);
            return packetFilteringTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
    }

    @Override
    public NextAction processRequest(Packet request) {
        if (this.isClientSide) {
            try {
                for (PacketFilter filter : this.filters) {
                    if (request != null) {
                        request = filter.filterClientRequest(request);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.logSevereException(ex);
                if (ex instanceof RuntimeException) {
                    return this.doThrow(ex);
                }
                return this.doThrow(new WebServiceException((Throwable)ex));
            }
            if (request == null) {
                return this.doThrow(new WebServiceException((Throwable)new IOException("Simulated IO error while sending request")));
            }
        }
        return super.processRequest(request);
    }

    @Override
    public NextAction processResponse(Packet response) {
        if (!this.isClientSide) {
            try {
                for (PacketFilter filter : this.filters) {
                    if (response != null) {
                        response = filter.filterServerResponse(response);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.logSevereException(ex);
                if (ex instanceof RuntimeException) {
                    return this.doThrow(ex);
                }
                return this.doThrow(new WebServiceException((Throwable)ex));
            }
        }
        return super.processResponse(response);
    }

    private List<PacketFilter> getConfiguredFilters(WSBinding binding, RxConfiguration configuration) {
        PacketFilteringFeature pfFeature = binding.getFeature(PacketFilteringFeature.class);
        return pfFeature.createFilters(configuration);
    }
}

