/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.impl.PasswordDerivedKey;
import com.sun.xml.ws.security.opt.api.EncryptedKey;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedKey;
import com.sun.xml.ws.security.opt.impl.keyinfo.KerberosTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.UsernameTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.X509TokenBuilder;
import com.sun.xml.ws.security.opt.impl.tokens.UsernameToken;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import javax.crypto.SecretKey;

public class SymmetricTokenBuilder
extends TokenBuilder {
    private Key dataProtectionKey = null;
    private Key keyProtectionKey = null;
    private SymmetricKeyBinding binding = null;
    private String dataProtectionAlg;
    private String keyProtectionAlg;
    private BuilderResult result;

    public SymmetricTokenBuilder(SymmetricKeyBinding binding, JAXBFilterProcessingContext context, String dpAlgo, String kpAlgo) {
        super(context);
        this.binding = binding;
        this.dataProtectionAlg = dpAlgo;
        this.keyProtectionAlg = kpAlgo;
    }

    public BuilderResult process() throws XWSSecurityException {
        boolean wss11Receiver = "true".equals(this.context.getExtraneousProperty("EnableWSS11PolicyReceiver"));
        boolean wss11Sender = "true".equals(this.context.getExtraneousProperty("EnableWSS11PolicySender"));
        boolean sendEKSHA1 = wss11Receiver && wss11Sender;
        boolean wss10 = !wss11Sender;
        ((NamespaceContextEx)this.context.getNamespaceContext()).addEncryptionNS();
        if (sendEKSHA1 && this.context.getExtraneousProperty("SecretKeyValue") == null) {
            sendEKSHA1 = false;
        }
        BuilderResult stbResult = new BuilderResult();
        WSSPolicy ckBinding = (WSSPolicy)this.binding.getKeyBinding();
        MLSPolicy mlspolicy = ckBinding.getKeyBinding();
        if (PolicyTypeUtil.UsernameTokenBinding(ckBinding)) {
            if (sendEKSHA1) {
                String ekSha1Ref = (String)this.context.getExtraneousProperty("EKSHA1Value");
                this.buildKeyInfoWithEKSHA1(ekSha1Ref);
                this.dataProtectionKey = this.binding.getSecretKey();
                stbResult.setKeyInfo(this.keyInfo);
                stbResult.setDataProtectionKey(this.dataProtectionKey);
            } else if (wss11Sender || wss10) {
                AuthenticationTokenPolicy.UsernameTokenBinding untBinding = null;
                this.dataProtectionKey = this.binding.getSecretKey();
                if (this.context.getusernameTokenBinding() == null) {
                    throw new XWSSecurityException("Internal error: UsernameToken Binding not set on context");
                }
                untBinding = this.context.getusernameTokenBinding();
                untBinding.setReferenceType("Direct");
                UsernameToken unt = untBinding.getUsernameToken();
                String unTokenId = untBinding.getUUID();
                if (unTokenId == null || unTokenId.equals("")) {
                    unTokenId = this.context.generateID();
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "UsernameToken for SymmetricBinding is: " + unt);
                    logger.log(Level.FINEST, "Token ID for SymmetricBinding is: " + unTokenId);
                }
                SecurityHeaderElement ek = null;
                HashMap ekCache = this.context.getEncryptedKeyCache();
                String ekId = (String)ekCache.get(unTokenId);
                this.keyProtectionKey = untBinding.getSecretKey();
                if (ekId == null) {
                    UsernameTokenBuilder builder = new UsernameTokenBuilder(this.context, untBinding);
                    this.result = builder.process();
                    KeyInfo ekKI = this.result.getKeyInfo();
                    this.context.setExtraneousProperty("SecretKey", this.dataProtectionKey);
                    byte[] secretKey = untBinding.getSecretKey().getEncoded();
                    PasswordDerivedKey pdk = new PasswordDerivedKey();
                    SecretKey dpKey = pdk.generate16ByteKeyforEncryption(secretKey);
                    ek = (SecurityHeaderElement)((Object)this.elementFactory.createEncryptedKey(this.context.generateID(), this.context.getAlgorithmSuite().getSymmetricKeyAlgorithm(), ekKI, dpKey, this.dataProtectionKey));
                    this.context.getSecurityHeader().add(ek);
                    ekId = ek.getId();
                    ekCache.put(unTokenId, ekId);
                    this.context.addToCurrentSecretMap(ekId, this.dataProtectionKey);
                    try {
                        byte[] cipherVal = ((JAXBEncryptedKey)ek).getCipherValue();
                        byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(cipherVal);
                        String encEkSha1 = Base64.encode(ekSha1);
                        this.context.setExtraneousProperty("EncryptedKeySHA1", encEkSha1);
                    }
                    catch (NoSuchAlgorithmException nsa) {
                        throw new XWSSecurityException(nsa);
                    }
                } else {
                    if (ekId == null || ekId.length() == 0) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1804_WRONG_ENCRYPTED_KEY());
                        throw new XWSSecurityException("Invalid EncryptedKey Id ");
                    }
                    this.dataProtectionKey = this.context.getCurrentSecretFromMap(ekId);
                }
                String valType = null;
                if (wss11Sender) {
                    valType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey";
                }
                SecurityTokenReference str = this.buildSTR(untBinding.getUUID(), this.buildDirectReference(ekId, valType));
                this.buildKeyInfo(str);
                stbResult.setDataProtectionKey(this.dataProtectionKey);
                stbResult.setKeyInfo(this.keyInfo);
                stbResult.setEncryptedKey((EncryptedKey)((Object)ek));
            }
        } else if (!PolicyTypeUtil.kerberosTokenBinding(ckBinding)) {
            if (!this.binding.getKeyIdentifier().equals(MessageConstants._EMPTY)) {
                if (this.keyProtectionAlg != null && !"".equals(this.keyProtectionAlg)) {
                    this.dataProtectionKey = SecurityUtil.generateSymmetricKey(this.dataProtectionAlg);
                }
                this.keyProtectionKey = this.binding.getSecretKey();
                if (this.dataProtectionKey == null) {
                    this.dataProtectionKey = this.keyProtectionKey;
                    this.keyProtectionKey = null;
                    this.buildKIWithKeyName(this.binding.getKeyIdentifier());
                }
                stbResult.setKeyInfo(this.keyInfo);
                stbResult.setDataProtectionKey(this.dataProtectionKey);
            } else if (sendEKSHA1) {
                String ekSha1Ref = (String)this.context.getExtraneousProperty("EKSHA1Value");
                this.buildKeyInfoWithEKSHA1(ekSha1Ref);
                this.dataProtectionKey = this.binding.getSecretKey();
                stbResult.setKeyInfo(this.keyInfo);
                stbResult.setDataProtectionKey(this.dataProtectionKey);
            } else if (wss11Sender || wss10) {
                X509Certificate x509Cert;
                this.dataProtectionKey = this.binding.getSecretKey();
                AuthenticationTokenPolicy.X509CertificateBinding certificateBinding = null;
                if (!this.binding.getCertAlias().equals(MessageConstants._EMPTY)) {
                    certificateBinding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    certificateBinding.setCertificateIdentifier(this.binding.getCertAlias());
                    x509Cert = this.context.getSecurityEnvironment().getCertificate(this.context.getExtraneousProperties(), certificateBinding.getCertificateIdentifier(), false);
                    certificateBinding.setX509Certificate(x509Cert);
                    certificateBinding.setReferenceType("Direct");
                } else if (this.context.getX509CertificateBinding() != null) {
                    certificateBinding = this.context.getX509CertificateBinding();
                    this.context.setX509CertificateBinding(null);
                } else {
                    throw new XWSSecurityException("Internal Error: X509CertificateBinding not set on context");
                }
                x509Cert = certificateBinding.getX509Certificate();
                String x509TokenId = certificateBinding.getUUID();
                if (x509TokenId == null || x509TokenId.equals("")) {
                    x509TokenId = this.context.generateID();
                }
                SecurityUtil.checkIncludeTokenPolicyOpt(this.context, certificateBinding, x509TokenId);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Certificate for SymmetricBinding is: " + x509Cert);
                    logger.log(Level.FINEST, "BinaryToken ID for SymmetricBinding is: " + x509TokenId);
                }
                Object bst = null;
                SecurityHeaderElement ek = null;
                HashMap ekCache = this.context.getEncryptedKeyCache();
                String ekId = (String)ekCache.get(x509TokenId);
                this.keyProtectionKey = x509Cert.getPublicKey();
                if (ekId == null) {
                    X509TokenBuilder builder = new X509TokenBuilder(this.context, certificateBinding);
                    BuilderResult result = builder.process();
                    KeyInfo ekKI = result.getKeyInfo();
                    this.context.setExtraneousProperty("SecretKey", this.dataProtectionKey);
                    ek = (SecurityHeaderElement)((Object)this.elementFactory.createEncryptedKey(this.context.generateID(), this.keyProtectionAlg, ekKI, this.keyProtectionKey, this.dataProtectionKey));
                    this.context.getSecurityHeader().add(ek);
                    ekId = ek.getId();
                    ekCache.put(x509TokenId, ekId);
                    this.context.addToCurrentSecretMap(ekId, this.dataProtectionKey);
                    stbResult.setEncryptedKey((EncryptedKey)((Object)ek));
                    try {
                        byte[] cipherVal = ((JAXBEncryptedKey)ek).getCipherValue();
                        byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(cipherVal);
                        String encEkSha1 = Base64.encode(ekSha1);
                        this.context.setExtraneousProperty("EncryptedKeySHA1", encEkSha1);
                    }
                    catch (NoSuchAlgorithmException nsa) {
                        throw new XWSSecurityException(nsa);
                    }
                } else {
                    if (ekId == null || ekId.length() == 0) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1804_WRONG_ENCRYPTED_KEY());
                        throw new XWSSecurityException("Invalid EncryptedKey Id ");
                    }
                    this.dataProtectionKey = this.context.getCurrentSecretFromMap(ekId);
                }
                String valType = null;
                if (wss11Sender) {
                    valType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey";
                }
                SecurityTokenReference str = this.buildSTR(certificateBinding.getUUID(), this.buildDirectReference(ekId, valType));
                this.buildKeyInfo(str);
                stbResult.setDataProtectionKey(this.dataProtectionKey);
                stbResult.setKeyInfo(this.keyInfo);
                stbResult.setEncryptedKey((EncryptedKey)((Object)ek));
            }
        } else {
            AuthenticationTokenPolicy.KerberosTokenBinding krbBinding = null;
            if (this.context.getKerberosTokenBinding() != null) {
                krbBinding = this.context.getKerberosTokenBinding();
                this.context.setKerberosTokenBinding(null);
                this.dataProtectionKey = krbBinding.getSecretKey();
                KerberosTokenBuilder builder = new KerberosTokenBuilder(this.context, krbBinding);
                stbResult = builder.process();
                stbResult.setDataProtectionKey(this.dataProtectionKey);
            } else {
                throw new XWSSecurityException("Internal error: Kerberos Binding not set on context");
            }
        }
        return stbResult;
    }
}

