/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.Descriptor;
import javax.management.modelmbean.DescriptorSupport;
import org.glassfish.gmbal.impl.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorUtility {
    public static final Descriptor EMPTY_DESCRIPTOR = DescriptorUtility.makeDescriptor(new HashMap());

    private DescriptorUtility() {
    }

    public static Descriptor makeDescriptor(Map<String, ?> fields) {
        if (fields == null) {
            throw Exceptions.self.nullMap();
        }
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String name = entry.getKey();
            if (name == null || name.equals("")) {
                throw Exceptions.self.badFieldName();
            }
            if (map.containsKey(name)) {
                throw Exceptions.self.duplicateFieldName(name);
            }
            map.put(name, entry.getValue());
        }
        int size = map.size();
        String[] names = map.keySet().toArray(new String[size]);
        Object[] values = map.values().toArray(new Object[size]);
        return new DescriptorSupport(names, values);
    }

    private static SortedMap<String, ?> makeMap(String[] fieldNames, Object[] fieldValues) {
        if (fieldNames == null || fieldValues == null) {
            throw Exceptions.self.nullArrayParameter();
        }
        if (fieldNames.length != fieldValues.length) {
            throw Exceptions.self.differentSizeArrays();
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            if (name == null || name.equals("")) {
                throw Exceptions.self.badFieldName();
            }
            Object old = map.put(name, fieldValues[i]);
            if (old == null) continue;
            throw Exceptions.self.duplicateFieldName(name);
        }
        return map;
    }

    public static Descriptor union(Descriptor ... descriptors) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Descriptor d : descriptors) {
            String[] names;
            if (d == null) continue;
            for (String n : names = d.getFieldNames()) {
                boolean equal;
                Object v = d.getFieldValue(n);
                Object old = map.put(n, v);
                if (old == null || (equal = old.getClass().isArray() ? Arrays.deepEquals(new Object[]{old}, new Object[]{v}) : old.equals(v))) continue;
                throw Exceptions.self.excForUnion(n, old, v);
            }
        }
        return DescriptorUtility.makeDescriptor(map);
    }

    public static Map<String, ?> getMap(Descriptor desc) {
        String[] names = desc.getFieldNames();
        Object[] values = desc.getFieldValues(names);
        return DescriptorUtility.makeMap(names, values);
    }
}

