/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.oa.poa.DelegateImpl;
import com.sun.corba.ee.impl.oa.poa.POAFactory;
import com.sun.corba.ee.impl.oa.poa.POAImpl;
import com.sun.corba.ee.impl.oa.poa.POAManagerImpl;
import com.sun.corba.ee.impl.oa.poa.POAPolicyMediator;
import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.ORBConstants;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;

public abstract class POAPolicyMediatorBase
implements POAPolicyMediator {
    protected POAImpl poa;
    protected ORB orb;
    private int sysIdCounter;
    private Policies policies;
    private DelegateImpl delegateImpl;
    private int serverid;
    private int scid;
    protected boolean isImplicit;
    protected boolean isUnique;
    protected boolean isSystemId;

    public final Policies getPolicies() {
        return this.policies;
    }

    public final int getScid() {
        return this.scid;
    }

    public final int getServerId() {
        return this.serverid;
    }

    POAPolicyMediatorBase(Policies policies, POAImpl poa) {
        if (policies.isSingleThreaded()) {
            throw poa.invocationWrapper().singleThreadNotSupported();
        }
        POAManagerImpl poam = (POAManagerImpl)poa.the_POAManager();
        POAFactory poaf = poam.getFactory();
        this.delegateImpl = (DelegateImpl)poaf.getDelegateImpl();
        this.policies = policies;
        this.poa = poa;
        this.orb = poa.getORB();
        switch (policies.servantCachingLevel()) {
            case 0: {
                this.scid = 32;
                break;
            }
            case 1: {
                this.scid = 36;
                break;
            }
            case 2: {
                this.scid = 40;
                break;
            }
            case 3: {
                this.scid = 44;
            }
        }
        if (policies.isTransient()) {
            this.serverid = this.orb.getTransientServerId();
        } else {
            this.serverid = this.orb.getORBData().getPersistentServerId();
            this.scid = ORBConstants.makePersistent(this.scid);
        }
        this.isImplicit = policies.isImplicitlyActivated();
        this.isUnique = policies.isUniqueIds();
        this.isSystemId = policies.isSystemAssignedIds();
        this.sysIdCounter = 0;
    }

    public final Object getInvocationServant(byte[] id, String operation) throws ForwardRequest {
        Object result = this.internalGetServant(id, operation);
        return result;
    }

    protected final void setDelegate(Servant servant, byte[] id) {
        servant._set_delegate((Delegate)this.delegateImpl);
    }

    public synchronized byte[] newSystemId() throws WrongPolicy {
        if (!this.isSystemId) {
            throw new WrongPolicy();
        }
        byte[] array = new byte[8];
        ORBUtility.intToBytes(++this.sysIdCounter, array, 0);
        ORBUtility.intToBytes(this.poa.getPOAId(), array, 4);
        return array;
    }

    protected abstract Object internalGetServant(byte[] var1, String var2) throws ForwardRequest;
}

