/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver singleton = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return singleton;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver resolver) {
        singleton = resolver == null ? new DefaultPersistenceProviderResolver() : resolver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
        public static final String SERVICE_PROVIDER_FILE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
        private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Set<String> providerNames = this.getProviderNames(loader);
            ArrayList<PersistenceProvider> loadedProviders = new ArrayList<PersistenceProvider>();
            for (String s : providerNames) {
                try {
                    PersistenceProvider provider = (PersistenceProvider)loader.loadClass(s).newInstance();
                    loadedProviders.add(provider);
                }
                catch (ClassNotFoundException exc) {
                }
                catch (InstantiationException exc) {
                }
                catch (IllegalAccessException exc) {}
            }
            return loadedProviders;
        }

        private Set<String> getProviderNames(ClassLoader loader) {
            Enumeration<URL> resources = null;
            try {
                resources = loader.getResources(SERVICE_PROVIDER_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HashSet<String> providerNames = new HashSet<String>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                providerNames.addAll(this.getProviderNames(url));
            }
            return providerNames;
        }

        private Set<String> getProviderNames(URL url) {
            HashSet<String> providerNames = new HashSet<String>();
            InputStream in = null;
            try {
                String line;
                in = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    Matcher m = nonCommentPattern.matcher(line = line.trim());
                    if (!m.find()) continue;
                    providerNames.add(m.group().trim());
                }
            }
            catch (IOException ioe) {
                throw new PersistenceException("IOException caught reading: " + url);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            return providerNames;
        }
    }
}

