/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.glassfish.appclient.client.acc.ACCModulesManager;

public class Util {
    private static Class thisClass = Util.class;
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(thisClass);

    public static File verifyFilePath(String filePath) throws FileNotFoundException, IOException {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        if (!f.canRead()) {
            String msg = localStrings.getLocalString(thisClass, "appclient.notReadable", "{0} is not a readable file", new Object[]{f.getAbsolutePath()});
            throw new IOException(msg);
        }
        return f;
    }

    static File verifyNonDirectoryFilePath(String filePath) throws FileNotFoundException, IOException {
        File f = Util.verifyFilePath(filePath);
        if (!f.isFile()) {
            String msg = localStrings.getLocalString(thisClass, "appclient.isDir", "{0} is a directory; it must be a readable non-directory file", new Object[]{f.getAbsolutePath()});
            throw new IOException(msg);
        }
        return f;
    }

    public static ArchiveFactory getArchiveFactory() {
        return ACCModulesManager.getComponent(ArchiveFactory.class);
    }

    public static ArchivistFactory getArchivistFactory() {
        return ACCModulesManager.getComponent(ArchivistFactory.class);
    }

    public static URI getURI(String s) throws URISyntaxException {
        return Util.getURI(new File(s));
    }

    public static URI getURI(File f) throws URISyntaxException {
        URI uri = f.toURI();
        if (f.isFile() && (f.getName().endsWith(".jar") || f.getName().endsWith(".ear"))) {
            uri = new URI("jar:" + uri.getRawSchemeSpecificPart());
        }
        return uri;
    }
}

