/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.callbackhandler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.glassfish.appclient.client.acc.callbackhandler.CallbackGUIBindings;
import org.glassfish.appclient.client.acc.callbackhandler.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGUICallbackHandler
implements CallbackHandler {
    private CallbackGUIBindings.Confirmation confirmationCallbackGUIBinding = null;
    private CallbackGUIBindings.MessageType messageType;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.messageType = CallbackGUIBindings.MessageType.PLAIN;
        ArrayList<CallbackGUIBindings.Binding> bindings = new ArrayList<CallbackGUIBindings.Binding>();
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        try {
            this.prepareComponentBindings(callbacks, bindings, components);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (CallbackGUIBindings.Binding binding : bindings) {
            CallbackGUIBindings.MessageType bindingType = binding.getMessageType();
            if (this.messageType.exceeds(bindingType)) continue;
            this.messageType = bindingType;
        }
        JOptionPane optionPane = new JOptionPane(components.toArray(new JComponent[components.size()]), this.confirmationCallbackGUIBinding.getOptionPaneOptionType(), this.messageType.getOptionPaneMessageType(), null, this.confirmationCallbackGUIBinding.getOptions(), this.confirmationCallbackGUIBinding.getDefaultOption());
        JDialog dialog = optionPane.createDialog(null, StringManager.getString("dialog.title", new Object[0]));
        dialog.setResizable(true);
        dialog.setVisible(true);
        int response = this.computeResponseValue(optionPane);
        dialog.dispose();
        for (CallbackGUIBindings.Binding binding : bindings) {
            binding.finish();
        }
        this.confirmationCallbackGUIBinding.setResult(response);
    }

    private int computeResponseValue(JOptionPane pane) {
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (pane.getOptions() == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = pane.getOptions().length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!pane.getOptions()[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    private void prepareComponentBindings(Callback[] callbacks, Collection<CallbackGUIBindings.Binding> bindings, Collection<JComponent> components) throws UnsupportedCallbackException, InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        CallbackGUIBindings factory = new CallbackGUIBindings();
        for (Callback callback : callbacks) {
            CallbackGUIBindings.Binding binding = factory.createCallbackGUIBinding(callback);
            bindings.add(binding);
            if (binding instanceof CallbackGUIBindings.Confirmation) {
                this.confirmationCallbackGUIBinding = (CallbackGUIBindings.Confirmation)binding;
            } else {
                components.add(binding.getComponent());
            }
            if (this.confirmationCallbackGUIBinding != null) continue;
            this.confirmationCallbackGUIBinding = factory.getDefaultConfirmationCallbackUIBinding();
        }
    }
}

