/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.security.api;

import com.sun.appserv.security.ProgrammaticLoginPermission;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.common.ProgrammaticLoginInterface;
import com.sun.enterprise.security.web.integration.WebProgrammaticLogin;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class ProgrammaticLogin
implements ProgrammaticLoginInterface {
    private WebProgrammaticLogin webProgrammaticLogin;
    private static Logger logger = LogDomains.getLogger(ProgrammaticLogin.class, (String)"javax.enterprise.system.core.security");
    private static ProgrammaticLoginPermission plLogin = new ProgrammaticLoginPermission("login");
    private static ProgrammaticLoginPermission plLogout = new ProgrammaticLoginPermission("logout");
    private static final String DEFAULT_WEBPROGRAMMATICLOGIN_IMPL = "com.sun.web.security.WebProgrammaticLoginImpl";
    private static CallbackHandler handler = new LoginCallbackHandler(false);

    public ProgrammaticLogin() {
        this.resolveWebProgrammaticLogin();
    }

    public Boolean login(final String user, final String password, final String realm, boolean errors) throws Exception {
        Boolean authenticated = null;
        try {
            this.checkLoginPermission(user);
            authenticated = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    if (SecurityServicesUtil.getInstance().isServer()) {
                        LoginContextDriver.login(user, password, realm);
                    } else {
                        int type = 1;
                        UsernamePasswordStore.set(user, password);
                        try {
                            LoginContextDriver.doClientLogin(type, handler);
                        }
                        finally {
                            UsernamePasswordStore.resetThreadLocalOnly();
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            logger.severe("Programmatic login failed: " + e.toString());
            if (errors) {
                throw e;
            }
            authenticated = false;
        }
        return authenticated;
    }

    public Boolean login(String user, String password) {
        Boolean authenticated = null;
        try {
            authenticated = this.login(user, password, null, false);
        }
        catch (Exception e) {
            authenticated = false;
        }
        return authenticated;
    }

    public Boolean login(final String user, final String password, final String realm, final HttpServletRequest request, final HttpServletResponse response, boolean errors) throws Exception {
        Boolean authenticated = null;
        try {
            this.checkLoginPermission(user);
            authenticated = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ProgrammaticLogin.this.webProgrammaticLogin.login(user, password, realm, request, response);
                }
            });
        }
        catch (Exception e) {
            if (!errors) {
                authenticated = false;
            }
            throw e;
        }
        return authenticated;
    }

    public Boolean login(String user, String password, HttpServletRequest request, HttpServletResponse response) {
        Boolean authenticated = null;
        try {
            authenticated = this.login(user, password, null, request, response, false);
        }
        catch (Exception e) {
            authenticated = false;
        }
        return authenticated;
    }

    public Boolean logout() {
        Boolean loggedout = null;
        try {
            loggedout = this.logout(false);
        }
        catch (Exception e) {
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(boolean errors) throws Exception {
        Boolean loggedout = null;
        try {
            this.checkLogoutPermission();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SecurityServicesUtil.getInstance().isServer()) {
                        LoginContextDriver.logout();
                    } else {
                        UsernamePasswordStore.reset();
                        LoginContextDriver.doClientLogout();
                    }
                    return null;
                }
            });
            loggedout = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Programmatic logout failed: " + e.toString());
            if (errors) {
                throw e;
            }
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(HttpServletRequest request, HttpServletResponse response) {
        Boolean loggedout = null;
        try {
            loggedout = this.logout(request, response, false);
        }
        catch (Exception e) {
            loggedout = false;
        }
        return loggedout;
    }

    public Boolean logout(final HttpServletRequest request, final HttpServletResponse response, boolean errors) throws Exception {
        Boolean loggedout = null;
        try {
            this.checkLogoutPermission();
            loggedout = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ProgrammaticLogin.this.webProgrammaticLogin.logout(request, response);
                }
            });
        }
        catch (Exception e) {
            if (errors) {
                throw e;
            }
            loggedout = false;
        }
        return loggedout;
    }

    private void checkLoginPermission(String user) throws Exception {
        try {
            SecurityManager sm;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ProgrammaticLogin.login() called for user: " + user);
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission((Permission)plLogin);
            }
        }
        catch (Exception e) {
            logger.warning("proglogin.noperm");
            throw e;
        }
    }

    private void checkLogoutPermission() throws Exception {
        try {
            SecurityManager sm;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ProgrammaticLogin.logout() called.");
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission((Permission)plLogout);
            }
        }
        catch (Exception e) {
            logger.warning("prologout.noperm");
            throw e;
        }
    }

    private void resolveWebProgrammaticLogin() {
        Habitat habitat = SecurityServicesUtil.getInstance().getHabitat();
        this.webProgrammaticLogin = (WebProgrammaticLogin)habitat.getComponent(WebProgrammaticLogin.class);
    }

    private WebProgrammaticLogin getWebProgrammaticLogin() {
        if (this.webProgrammaticLogin != null) {
            return this.webProgrammaticLogin;
        }
        throw new RuntimeException("Unresolved Reference : Could not Locate implementation class for WebProgrammaticLogin");
    }
}

