/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import javax.xml.namespace.QName;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.impl.WSDLFaultImpl;
import org.jvnet.wom.impl.WSDLInputImpl;
import org.jvnet.wom.impl.WSDLOperationImpl;
import org.jvnet.wom.impl.WSDLOutputImpl;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.jvnet.wom.impl.parser.handler.Fault;
import org.jvnet.wom.impl.parser.handler.Input;
import org.jvnet.wom.impl.parser.handler.Messages;
import org.jvnet.wom.impl.parser.handler.Output;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Operation
extends AbstractHandler {
    private WSDLOperationImpl operation;
    private WSDLContentHandlerEx runtime;
    private String expectedNS;

    public Operation(AbstractHandler parent, WSDLEventSource source, WSDLContentHandlerEx runtime, int cookie, String expectedNamespace) {
        super(source, parent, cookie);
        this.runtime = runtime;
        this.expectedNS = expectedNamespace;
    }

    protected Operation(WSDLEventSource source, AbstractHandler parent, int parentCookie) {
        super(source, parent, parentCookie);
    }

    protected WSDLContentHandlerEx getRuntime() {
        return this.runtime;
    }

    protected void onChildCompleted(Object result, int cookie, boolean needAttCheck) throws SAXException {
        switch (cookie) {
            case 611: {
                WSDLInputImpl input = (WSDLInputImpl)result;
                input.setParent(this.operation);
                this.operation.setInput(input);
                break;
            }
            case 612: {
                WSDLOutputImpl output = (WSDLOutputImpl)result;
                output.setParent(this.operation);
                this.operation.setOutput(output);
                break;
            }
            case 613: {
                WSDLFaultImpl fault = (WSDLFaultImpl)result;
                fault.setParent(this.operation);
                this.operation.addFault(fault);
            }
        }
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("operation")) {
            this.runtime.onEnterElementConsumed(uri, localName, qname, atts);
            Attributes test = this.runtime.getCurrentAttributes();
            this.processAttributes(test);
        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("input")) {
            Input input = new Input(this, this._source, this.runtime, 611, this.expectedNS);
            this.spawnChildFromEnterElement(input, uri, localName, qname, atts);
        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("output")) {
            Output output = new Output(this, this._source, this.runtime, 612, this.expectedNS);
            this.spawnChildFromEnterElement(output, uri, localName, qname, atts);
        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("fault")) {
            Fault fault = new Fault(this, this._source, this.runtime, 613, this.expectedNS);
            this.spawnChildFromEnterElement(fault, uri, localName, qname, atts);
        } else {
            super.enterElement(uri, localName, qname, atts);
        }
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("operation")) {
            this.endProcessingExtentionElement(this.operation);
            this.revertToParentFromLeaveElement(this.operation, this._cookie, uri, localName, qname);
            this.operation.setDocumentation(this.getWSDLDocumentation());
        }
    }

    private void processAttributes(Attributes test) throws SAXException {
        int index;
        int[] validattrs = new int[test.getLength()];
        String name = XmlUtil.fixNull(test.getValue("name"));
        if (name.equals("")) {
            this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.missingName", "wsdl:operation", name), this.runtime.getLocator()));
        }
        if ((index = test.getIndex("name")) >= 0) {
            validattrs[index] = 1;
        }
        this.operation = new WSDLOperationImpl(this.runtime.getLocator(), new QName(this.runtime.currentWSDL.getName().getNamespaceURI(), name), this.runtime.document);
        index = test.getIndex("parameterOrder");
        if (index >= 0) {
            validattrs[index] = 1;
            String paramOrder = test.getValue(index);
            String[] params = paramOrder.split("\\s");
            this.operation.setParameterOrder(params);
        }
        this.validateAttribute(this.runtime.getErrorHandler(), test, validattrs);
    }
}

