/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.security.provider.ProxyHandler;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UEncoder;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.StringManager;
import org.glassfish.web.valve.GlassFishValve;

public class CoyoteAdapter
implements Adapter {
    private static Logger log = Logger.getLogger(CoyoteAdapter.class.getName());
    protected boolean v3Enabled = Boolean.valueOf(System.getProperty("v3.grizzly.useMapper", "true"));
    public static final int ADAPTER_NOTES = 1;
    static final String JVM_ROUTE = System.getProperty("jvmRoute");
    protected static final boolean ALLOW_BACKSLASH = Boolean.valueOf(System.getProperty("com.sun.grizzly.tcp.tomcat5.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    private static final boolean COLLAPSE_ADJACENT_SLASHES = Boolean.valueOf(System.getProperty("com.sun.enterprise.web.collapseAdjacentSlashes", "true"));
    private boolean compatWithTomcat = false;
    private String serverName = System.getProperty("product.name");
    private static final int MAPPING_DATA = 12;
    private Connector connector = null;
    private int debug = 0;
    private UEncoder urlEncoder = new UEncoder();
    protected StringManager sm = StringManager.getManager("org.apache.catalina.connector");

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
        this.debug = connector.getDebug();
        this.urlEncoder.addSafeCharacter('/');
    }

    public void service(com.sun.grizzly.tcp.Request req, com.sun.grizzly.tcp.Response res) throws Exception {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        MappingData md = (MappingData)req.getNote(12);
        this.v3Enabled = md != null;
        if (request == null) {
            request = (Request)this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = (Response)this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, request);
            res.setNote(1, response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        String hostName = null;
        if (this.v3Enabled && !this.compatWithTomcat && md != null) {
            request.setMappingData(md);
            hostName = ((Host)md.host).getName();
        }
        this.connector.requestStartEvent(request.getRequest(), response.getResponse(), hostName);
        try {
            this.doService(req, request, res, response);
        }
        catch (IOException e) {
            this.connector.requestEndEvent(request.getRequest(), response.getResponse(), hostName, response.getStatus());
            request.recycle();
            response.recycle();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, this.sm.getString("coyoteAdapter.service"), t);
            this.connector.requestEndEvent(request.getRequest(), response.getResponse(), hostName, response.getStatus());
            request.recycle();
            response.recycle();
        }
    }

    private void doService(com.sun.grizzly.tcp.Request req, Request request, com.sun.grizzly.tcp.Response res, Response response) throws Exception {
        if (!this.connector.isEnabled()) {
            String msg = this.sm.getString("coyoteAdapter.listenerOff", String.valueOf(this.connector.getPort()));
            if (log.isLoggable(Level.FINE)) {
                log.fine(msg);
            }
            response.sendError(404, msg);
            return;
        }
        if (this.connector.isXpoweredBy()) {
            response.addHeader("X-Powered-By", "Servlet/3.0");
        }
        if (this.postParseRequest(req, request, res, response)) {
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null) {
                if (proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                    request.setSecure(true);
                }
                X509Certificate[] certs = null;
                try {
                    certs = proxyHandler.getSSLClientCertificateChain(request.getRequest());
                }
                catch (CertificateException ce) {
                    log.log(Level.SEVERE, this.sm.getString("coyoteAdapter.proxyAuthCertError"), ce);
                }
                if (certs != null) {
                    request.setAttribute("javax.servlet.request.X509Certificate", certs);
                }
            }
            response.addHeader("Server", this.serverName);
            Container container = this.connector.getContainer();
            if (container.getPipeline().hasNonBasicValves() || container.hasCustomPipeline()) {
                container.getPipeline().invoke(request, response);
            } else {
                Host host = request.getHost();
                if (host == null) {
                    response.sendError(400);
                    response.setDetailMessage(this.sm.getString("standardEngine.noHost", request.getRequest().getServerName()));
                    return;
                }
                if (host.getPipeline().hasNonBasicValves() || host.hasCustomPipeline()) {
                    host.getPipeline().invoke(request, response);
                } else {
                    GlassFishValve hostValve = host.getPipeline().getBasic();
                    hostValve.invoke(request, response);
                    hostValve.postInvoke(request, response);
                }
            }
        }
        if (this.compatWithTomcat) {
            this.afterService(req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterService(com.sun.grizzly.tcp.Request req, com.sun.grizzly.tcp.Response res) throws Exception {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        if (request == null || response == null) {
            return;
        }
        try {
            block8: {
                try {
                    if (res.isSuspended()) break block8;
                    response.finishResponse();
                    req.action(ActionCode.ACTION_POST_REQUEST, null);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, this.sm.getString("coyoteAdapter.service"), t);
                    Object var7_6 = null;
                    String hostName = null;
                    MappingData md = request.getMappingData();
                    if (md != null && md.host != null) {
                        hostName = ((Host)md.host).getName();
                    }
                    this.connector.requestEndEvent(request.getRequest(), response.getResponse(), hostName, response.getStatus());
                    request.recycle();
                    response.recycle();
                }
            }
            Object var7_5 = null;
            String hostName = null;
            MappingData md = request.getMappingData();
            if (md != null && md.host != null) {
                hostName = ((Host)md.host).getName();
            }
            this.connector.requestEndEvent(request.getRequest(), response.getResponse(), hostName, response.getStatus());
            request.recycle();
            response.recycle();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            String hostName = null;
            MappingData md = request.getMappingData();
            if (md != null && md.host != null) {
                hostName = ((Host)md.host).getName();
            }
            this.connector.requestEndEvent(request.getRequest(), response.getResponse(), hostName, response.getStatus());
            request.recycle();
            response.recycle();
            throw throwable;
        }
    }

    protected boolean postParseRequest(com.sun.grizzly.tcp.Request req, Request request, com.sun.grizzly.tcp.Response res, Response response) throws Exception {
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        MessageBytes decodedURI = req.decodedURI();
        if (this.compatWithTomcat || !this.v3Enabled) {
            String authtype;
            decodedURI.duplicate(req.requestURI());
            try {
                req.getURLDecoder().convert(decodedURI, false);
            }
            catch (IOException ioe) {
                res.setStatus(400);
                res.setMessage("Invalid URI: " + ioe.getMessage());
                return false;
            }
            String principal = req.getRemoteUser().toString();
            if (principal != null) {
                request.setUserPrincipal(new CoyotePrincipal(principal));
            }
            if ((authtype = req.getAuthType().toString()) != null) {
                request.setAuthType(authtype);
            }
            request.convertURI(decodedURI);
            if (!CoyoteAdapter.normalize(decodedURI)) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                return false;
            }
        }
        request.parseSessionId();
        CharChunk uriCC = decodedURI.getCharChunk();
        int semicolon = uriCC.indexOf(';');
        String sessionVersionString = null;
        if (semicolon > 0) {
            sessionVersionString = request.parseSessionVersion();
            decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), semicolon);
        }
        if (this.compatWithTomcat || !this.v3Enabled) {
            this.connector.getMapper().map(req.serverName(), decodedURI, request.getMappingData());
        }
        request.setDefaultContext(request.getMappingData().isDefaultContext);
        Context ctx = (Context)request.getMappingData().context;
        request.setContext(ctx);
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            String header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (int i = 0; i < methods.length; ++i) {
                    if ("TRACE".equals(methods[i])) continue;
                    header = header == null ? methods[i] : header + ", " + methods[i];
                }
            }
            res.setStatus(405);
            res.addHeader("Allow", header);
            res.setMessage("TRACE method is not allowed");
            return false;
        }
        MessageBytes redirectPathMB = request.getMappingData().redirectPath;
        if (!(redirectPathMB.isNull() || ctx.hasAdHocPaths() && ctx.getAdHocServletName(request.getRequest().getServletPath()) != null)) {
            String redirectPath = redirectPathMB.toString();
            String query = request.getQueryString();
            if (request.isRequestedSessionIdFromURL()) {
                redirectPath = redirectPath + ";" + "jsessionid" + "=" + request.getRequestedSessionId();
            }
            redirectPath = this.urlEncoder.encodeURL(redirectPath);
            if (query != null) {
                redirectPath = redirectPath + "?" + query;
            }
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null && proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                request.setSecure(true);
            }
            response.sendRedirect(redirectPath, false);
            return false;
        }
        request.parseSessionCookiesId();
        request.parseJrouteCookie();
        if (sessionVersionString != null) {
            request.parseSessionVersionString(sessionVersionString);
        }
        return true;
    }

    public static boolean normalize(MessageBytes uriMB) {
        int type = uriMB.getType();
        if (type == 3) {
            return CoyoteAdapter.normalizeChars(uriMB);
        }
        return CoyoteAdapter.normalizeBytes(uriMB);
    }

    private static boolean normalizeBytes(MessageBytes uriMB) {
        int end;
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        if (start == (end = uriBC.getEnd())) {
            return false;
        }
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (ALLOW_BACKSLASH) {
                    b[pos] = 47;
                } else {
                    return false;
                }
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (b[pos] != 47) continue;
                while (pos + 1 < end && b[pos + 1] == 47) {
                    CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    private static boolean normalizeChars(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        if (end - start == 1 && c[start] == '*') {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                if (ALLOW_BACKSLASH) {
                    c[pos] = 47;
                } else {
                    return false;
                }
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        if (c[start] != '/') {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (c[pos] != '/') continue;
                while (pos + 1 < end && c[pos + 1] == '/') {
                    CoyoteAdapter.copyChars(c, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            c[end] = 47;
            ++end;
        }
        uriCC.setEnd(end);
        index = 0;
        while ((index = uriCC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            uriCC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriCC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            CoyoteAdapter.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriCC.setEnd(end);
            index = index2;
        }
        uriCC.setChars(c, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    private static void copyChars(char[] c, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            c[pos + dest] = c[pos + src];
        }
    }

    protected void log(String message) {
        log.info(message);
    }

    protected void log(String message, Throwable throwable) {
        log.log(Level.SEVERE, message, throwable);
    }

    public void fireAdapterEvent(String type, Object data) {
        if (this.connector != null && this.connector.getContainer() != null) {
            try {
                ((ContainerBase)this.connector.getContainer()).fireContainerEvent(type, data);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, this.sm.getString("coyoteAdapter.service"), t);
            }
        }
    }

    public boolean isCompatWithTomcat() {
        return this.compatWithTomcat;
    }

    public void setCompatWithTomcat(boolean compatWithTomcat) {
        this.compatWithTomcat = compatWithTomcat;
        this.serverName = compatWithTomcat ? "Apache/" + this.serverName : System.getProperty("product.name");
    }

    public int getPort() {
        return this.connector.getPort();
    }
}

