/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model;

import com.sun.istack.NotNull;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.ws.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrapperBeanGenerator<T, C, M, A extends Comparable> {
    private static final Logger LOGGER = Logger.getLogger(AbstractWrapperBeanGenerator.class.getName());
    private static final String RETURN = "return";
    private static final String RETURN_VALUE = "_return";
    private static final String EMTPY_NAMESPACE_ID = "";
    private static final Class[] jaxbAnns = new Class[]{XmlAttachmentRef.class, XmlMimeType.class, XmlJavaTypeAdapter.class, XmlList.class, XmlElement.class};
    private static final Set<String> skipProperties = new HashSet<String>();
    private final AnnotationReader<T, ?, ?, M> annReader;
    private final Navigator<T, C, ?, M> nav;
    private final BeanMemberFactory<T, A> factory;
    private static final Map<String, String> reservedWords;

    protected AbstractWrapperBeanGenerator(AnnotationReader<T, ?, ?, M> annReader, Navigator<T, C, ?, M> nav, BeanMemberFactory<T, A> factory) {
        this.annReader = annReader;
        this.nav = nav;
        this.factory = factory;
    }

    private List<Annotation> collectJAXBAnnotations(M method) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        for (Class jaxbClass : jaxbAnns) {
            Annotation ann = this.annReader.getMethodAnnotation(jaxbClass, method, null);
            if (ann == null) continue;
            jaxbAnnotation.add(ann);
        }
        return jaxbAnnotation;
    }

    private List<Annotation> collectJAXBAnnotations(M method, int paramIndex) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        for (Class jaxbClass : jaxbAnns) {
            Annotation ann = this.annReader.getMethodParameterAnnotation(jaxbClass, method, paramIndex, null);
            if (ann == null) continue;
            jaxbAnnotation.add(ann);
        }
        return jaxbAnnotation;
    }

    protected abstract T getSafeType(T var1);

    protected abstract T getHolderValueType(T var1);

    protected abstract boolean isVoidType(T var1);

    public List<A> collectRequestBeanMembers(M method, boolean wrapped, String typeNamespace) {
        ArrayList<Comparable> requestMembers = new ArrayList<Comparable>();
        int paramIndex = -1;
        for (Object param : this.nav.getMethodParameters(method)) {
            String paramNamespace;
            List<Annotation> jaxbAnnotation = this.collectJAXBAnnotations(method, ++paramIndex);
            WebParam.Mode mode = null;
            Object holderType = this.getHolderValueType(param);
            WebParam webParam = (WebParam)this.annReader.getMethodParameterAnnotation(WebParam.class, method, paramIndex, null);
            Object paramType = this.getSafeType(param);
            String string2 = paramNamespace = wrapped ? EMTPY_NAMESPACE_ID : typeNamespace;
            if (holderType != null) {
                paramType = holderType;
            }
            String paramName = "arg" + paramIndex;
            if (webParam != null && webParam.header()) continue;
            if (webParam != null) {
                mode = webParam.mode();
                if (webParam.name().length() > 0) {
                    paramName = webParam.name();
                }
                if (webParam.targetNamespace().length() > 0) {
                    paramNamespace = webParam.targetNamespace();
                }
            }
            String propertyName = JAXBRIContext.mangleNameToVariableName((String)paramName);
            propertyName = AbstractWrapperBeanGenerator.getJavaReservedVarialbeName(propertyName);
            this.processXmlElement(jaxbAnnotation, paramName, paramNamespace, paramType);
            Comparable member = (Comparable)this.factory.createWrapperBeanMember(paramType, propertyName, new QName(paramNamespace, paramName), jaxbAnnotation);
            if (holderType != null) {
                if (mode != null && !mode.equals((Object)WebParam.Mode.INOUT)) continue;
                requestMembers.add(member);
                continue;
            }
            requestMembers.add(member);
        }
        return requestMembers;
    }

    public List<A> collectResponseBeanMembers(M method, boolean wrapped, String typeNamespace) {
        ArrayList<Object> responseMembers = new ArrayList<Object>();
        List<Annotation> jaxbRespAnnotations = this.collectJAXBAnnotations(method);
        String responseElementName = RETURN;
        String responseName = RETURN_VALUE;
        String responseNamespace = wrapped ? EMTPY_NAMESPACE_ID : typeNamespace;
        boolean isResultHeader = false;
        WebResult webResult = (WebResult)this.annReader.getMethodAnnotation(WebResult.class, method, null);
        if (webResult != null) {
            if (webResult.name().length() > 0) {
                responseElementName = webResult.name();
                responseName = JAXBRIContext.mangleNameToVariableName((String)webResult.name());
                responseName = AbstractWrapperBeanGenerator.getJavaReservedVarialbeName(responseName);
            }
            responseNamespace = webResult.targetNamespace().length() > 1 ? webResult.targetNamespace() : responseNamespace;
            isResultHeader = webResult.header();
        }
        Object returnType = this.getSafeType(this.nav.getReturnType(method));
        if (!this.isVoidType(this.nav.getReturnType(method)) && !isResultHeader) {
            this.processXmlElement(jaxbRespAnnotations, responseElementName, responseNamespace, returnType);
            responseMembers.add(this.factory.createWrapperBeanMember(returnType, responseName, new QName(responseNamespace, responseElementName), jaxbRespAnnotations));
        }
        int paramIndex = -1;
        for (Object param : this.nav.getMethodParameters(method)) {
            String paramNamespace;
            List<Annotation> jaxbAnnotation = this.collectJAXBAnnotations(method, ++paramIndex);
            WebParam.Mode mode = null;
            Object holderType = this.getHolderValueType(param);
            WebParam webParam = (WebParam)this.annReader.getMethodParameterAnnotation(WebParam.class, method, paramIndex, null);
            Object paramType = this.getSafeType(param);
            String string2 = paramNamespace = wrapped ? EMTPY_NAMESPACE_ID : typeNamespace;
            if (holderType != null) {
                paramType = holderType;
            }
            String paramName = "arg" + paramIndex;
            if (webParam != null && webParam.header()) continue;
            if (webParam != null) {
                mode = webParam.mode();
                if (webParam.name().length() > 0) {
                    paramName = webParam.name();
                }
                if (webParam.targetNamespace().length() > 0) {
                    paramNamespace = webParam.targetNamespace();
                }
            }
            String propertyName = JAXBRIContext.mangleNameToVariableName((String)paramName);
            propertyName = AbstractWrapperBeanGenerator.getJavaReservedVarialbeName(propertyName);
            this.processXmlElement(jaxbAnnotation, paramName, paramNamespace, paramType);
            Comparable member = (Comparable)this.factory.createWrapperBeanMember(paramType, propertyName, new QName(paramNamespace, paramName), jaxbAnnotation);
            if (holderType == null) continue;
            if (mode == null || mode.equals((Object)WebParam.Mode.INOUT)) {
                // empty if block
            }
            responseMembers.add(member);
        }
        return responseMembers;
    }

    private void processXmlElement(List<Annotation> jaxb, String elemName, String elemNS, T type) {
        XmlElement elemAnn = null;
        for (Annotation a : jaxb) {
            if (a.annotationType() != XmlElement.class) continue;
            elemAnn = (XmlElement)a;
            jaxb.remove(a);
            break;
        }
        String name = elemAnn != null && !elemAnn.name().equals("##default") ? elemAnn.name() : elemName;
        String ns = elemAnn != null && !elemAnn.namespace().equals("##default") ? elemAnn.namespace() : elemNS;
        boolean nillable = this.nav.isArray(type) || elemAnn != null && elemAnn.nillable();
        boolean required = elemAnn != null && elemAnn.required();
        XmlElementHandler handler = new XmlElementHandler(name, ns, nillable, required);
        XmlElement elem = (XmlElement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{XmlElement.class}, (InvocationHandler)handler);
        jaxb.add((Annotation)elem);
    }

    Collection<A> collectExceptionBeanMembers(C exception) {
        TreeSet fields = new TreeSet();
        this.getExceptionProperties(exception, fields);
        return fields;
    }

    private void getExceptionProperties(C exception, Set<A> fields) {
        Object sc = this.nav.getSuperClass(exception);
        if (sc != null) {
            this.getExceptionProperties(sc, fields);
        }
        Collection methods = this.nav.getDeclaredMethods(exception);
        for (Object method : methods) {
            String name;
            if (!this.nav.isPublicMethod(method) || !(name = this.nav.getMethodName(method)).startsWith("get") && !name.startsWith("is") || skipProperties.contains(name) || name.equals("get") || name.equals("is")) continue;
            Object returnType = this.nav.getReturnType(method);
            if (this.nav.getMethodParameters(method).length != 0) continue;
            String fieldName = name.startsWith("get") ? StringUtils.decapitalize(name.substring(3)) : StringUtils.decapitalize(name.substring(2));
            fields.add(this.factory.createWrapperBeanMember(returnType, fieldName, null, Collections.<Annotation>emptyList()));
        }
    }

    @NotNull
    private static String getJavaReservedVarialbeName(@NotNull String name) {
        String reservedName = reservedWords.get(name);
        return reservedName == null ? name : reservedName;
    }

    static {
        skipProperties.add("getCause");
        skipProperties.add("getLocalizedMessage");
        skipProperties.add("getClass");
        skipProperties.add("getStackTrace");
        reservedWords = new HashMap<String, String>();
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("assert", "_assert");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put(RETURN, RETURN_VALUE);
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
        reservedWords.put("enum", "_enum");
    }

    private static class XmlElementHandler
    implements InvocationHandler {
        private String name;
        private String namespace;
        private boolean nillable;
        private boolean required;

        XmlElementHandler(String name, String namespace, boolean nillable, boolean required) {
            this.name = name;
            this.namespace = namespace;
            this.nillable = nillable;
            this.required = required;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("name")) {
                return this.name;
            }
            if (methodName.equals("namespace")) {
                return this.namespace;
            }
            if (methodName.equals("nillable")) {
                return this.nillable;
            }
            if (methodName.equals("required")) {
                return this.required;
            }
            throw new WebServiceException("Not handling " + methodName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BeanMemberFactory<T, A> {
        public A createWrapperBeanMember(T var1, String var2, QName var3, List<Annotation> var4);
    }
}

