/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.management.internal.snmp.SnmpModelLcd;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpUnknownModelLcdException;
import com.sun.management.snmp.SnmpUnknownSubSystemException;
import java.util.Hashtable;

public abstract class SnmpLcd {
    private Hashtable subs = new Hashtable();

    public abstract int getEngineBoots();

    public abstract String getEngineId();

    public abstract void storeEngineBoots(int var1);

    public abstract void storeEngineId(SnmpEngineId var1);

    public void addModelLcd(SnmpSubSystem sys, int id, SnmpModelLcd lcd) {
        SubSysLcdManager subsys = (SubSysLcdManager)this.subs.get(sys);
        if (subsys == null) {
            subsys = new SubSysLcdManager();
            this.subs.put(sys, subsys);
        }
        subsys.addModelLcd(id, lcd);
    }

    public void removeModelLcd(SnmpSubSystem sys, int id) throws SnmpUnknownModelLcdException, SnmpUnknownSubSystemException {
        SubSysLcdManager subsys = (SubSysLcdManager)this.subs.get(sys);
        if (subsys != null) {
            SnmpModelLcd lcd = subsys.removeModelLcd(id);
            if (lcd == null) {
                throw new SnmpUnknownModelLcdException("Model : " + id);
            }
        } else {
            throw new SnmpUnknownSubSystemException(sys.toString());
        }
    }

    public SnmpModelLcd getModelLcd(SnmpSubSystem sys, int id) {
        SubSysLcdManager subsys = (SubSysLcdManager)this.subs.get(sys);
        if (subsys == null) {
            return null;
        }
        return subsys.getModelLcd(id);
    }

    class SubSysLcdManager {
        private Hashtable models = new Hashtable();

        SubSysLcdManager() {
        }

        public void addModelLcd(int id, SnmpModelLcd usmlcd) {
            this.models.put(new Integer(id), usmlcd);
        }

        public SnmpModelLcd getModelLcd(int id) {
            return (SnmpModelLcd)this.models.get(new Integer(id));
        }

        public SnmpModelLcd removeModelLcd(int id) {
            return (SnmpModelLcd)this.models.remove(new Integer(id));
        }
    }
}

