/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.glassfish.enterprise.iiop.impl.HandleDelegateClassLoader;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.Delegate;

public final class IIOPHandleDelegate
implements HandleDelegate {
    public static HandleDelegate getHandleDelegate() {
        HandleDelegate handleDelegate = (HandleDelegate)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    HandleDelegateClassLoader cl = new HandleDelegateClassLoader();
                    Class<?> c = cl.loadClass("org.glassfish.enterprise.iiop.impl.IIOPHandleDelegate");
                    return c.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error creating HandleDelegate", ex);
                }
            }
        });
        return handleDelegate;
    }

    public void writeEJBObject(EJBObject ejbObject, ObjectOutputStream ostream) throws IOException {
        ostream.writeObject(ejbObject);
    }

    public EJBObject readEJBObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        return (EJBObject)this.getStub(istream, EJBObject.class);
    }

    public void writeEJBHome(EJBHome ejbHome, ObjectOutputStream ostream) throws IOException {
        ostream.writeObject(ejbHome);
    }

    public EJBHome readEJBHome(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        return (EJBHome)this.getStub(istream, EJBHome.class);
    }

    private Object getStub(ObjectInputStream istream, Class stubClass) throws IOException, ClassNotFoundException {
        Object obj = istream.readObject();
        if (StubAdapter.isStub(obj)) {
            try {
                Delegate delegate = StubAdapter.getDelegate(obj);
            }
            catch (BAD_OPERATION bo) {
                ORB orb = null;
                try {
                    orb = (ORB)new InitialContext().lookup("java:comp/ORB");
                }
                catch (NamingException ne) {
                    throw new IOException("Error acquiring orb", ne);
                }
                StubAdapter.connect(obj, (ORB)((Object)((com.sun.corba.ee.spi.orb.ORB)((Object)orb))));
            }
        } else {
            throw new IOException("Unable to create stub for class " + stubClass.getName() + ", object deserialized is not a CORBA object, it's type is " + obj.getClass().getName());
        }
        Object stub = PortableRemoteObject.narrow((Object)obj, (Class)stubClass);
        return stub;
    }
}

