/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import java.lang.reflect.Method;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionManagement;

public class TransactionAnnotationProcessor {
    public static boolean isContainerManagedEJB(Class c) {
        boolean result = false;
        TransactionManagement tm = c.getAnnotation(TransactionManagement.class);
        if (tm != null) {
            switch (tm.value()) {
                case BEAN: {
                    return false;
                }
            }
            return true;
        }
        Stateful stateful = c.getAnnotation(Stateful.class);
        Stateless stateless = c.getAnnotation(Stateless.class);
        return c.getAnnotation(Stateful.class) != null || c.getAnnotation(Stateless.class) != null;
    }

    public static TransactionAttributeType getTransactionAttributeDefault(Class c) {
        TransactionAttributeType result = TransactionAttributeType.REQUIRED;
        TransactionAttribute txnAttr = c.getAnnotation(TransactionAttribute.class);
        if (txnAttr != null) {
            result = TransactionAnnotationProcessor.convert(txnAttr.value());
        }
        return result;
    }

    public static TransactionAttributeType getEffectiveTransactionAttribute(Method m, TransactionAttributeType defaultTxnAttr) {
        TransactionAttributeType result = defaultTxnAttr;
        TransactionAttribute txnAttr = m.getAnnotation(TransactionAttribute.class);
        if (txnAttr != null) {
            result = TransactionAnnotationProcessor.convert(txnAttr.value());
        }
        return result;
    }

    private static TransactionAttributeType convert(javax.ejb.TransactionAttributeType e) {
        return TransactionAttributeType.valueOf(TransactionAttributeType.class, e.name());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransactionAttributeType {
        NOT_SUPPORTED,
        NEVER,
        MANDATORY,
        SUPPORTS,
        REQUIRES_NEW,
        REQUIRED;

    }
}

