/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.impl.WSDLBoundPortTypeImpl;
import org.jvnet.wom.impl.WSDLMessageImpl;
import org.jvnet.wom.impl.WSDLPortTypeImpl;
import org.jvnet.wom.impl.WSDLServiceImpl;
import org.jvnet.wom.impl.parser.Messages;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.WSDLTypesImpl;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.jvnet.wom.impl.parser.handler.BoundPortType;
import org.jvnet.wom.impl.parser.handler.Message;
import org.jvnet.wom.impl.parser.handler.PortType;
import org.jvnet.wom.impl.parser.handler.Service;
import org.jvnet.wom.impl.parser.handler.Types;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Definitions
extends AbstractHandler {
    private int state;
    private final WSDLContentHandlerEx runtime;
    private final String expectedNamespace;

    public Definitions(AbstractHandler parent, WSDLEventSource source, WSDLContentHandlerEx runtime, int cookie, String expectedNamespace) {
        super(source, parent, cookie);
        this.runtime = runtime;
        this.expectedNamespace = expectedNamespace;
        this.state = 1;
    }

    public Definitions(WSDLContentHandlerEx runtime, String _expectedNamespace) {
        this(null, runtime, runtime, -1, _expectedNamespace);
    }

    protected WSDLContentHandlerEx getRuntime() {
        return this.runtime;
    }

    protected void onChildCompleted(Object result, int cookie, boolean needAttCheck) throws SAXException {
        switch (cookie) {
            case 50: {
                WSDLMessageImpl message = (WSDLMessageImpl)result;
                this.runtime.currentWSDL.addMessage(message);
                break;
            }
            case 60: {
                this.runtime.currentWSDL.addPortType((WSDLPortTypeImpl)result);
                break;
            }
            case 70: {
                this.runtime.currentWSDL.addBoundPortType((WSDLBoundPortTypeImpl)result);
                break;
            }
            case 80: {
                this.runtime.currentWSDL.addService((WSDLServiceImpl)result);
                break;
            }
            case 90: {
                this.runtime.currentWSDL.setWSDLTypes((WSDLTypesImpl)result);
            }
        }
    }

    private void readDefinitionQName() throws SAXException {
        Attributes test = this.runtime.getCurrentAttributes();
        String tns = XmlUtil.fixNull(test.getValue("targetNamespace"));
        String name = XmlUtil.fixNull(test.getValue("name"));
        this.runtime.currentWSDL = this.runtime.parser.wsdlSet.createWSDLDefinitions(name, tns, this.runtime.copyLocator());
        if (this.expectedNamespace != null && !this.expectedNamespace.equals(tns)) {
            this.runtime.reportError(Messages.format("UnexpectedTargetnamespace.Import", tns, this.expectedNamespace, tns), this.runtime.getLocator());
        }
        if (this.runtime.hasAlreadyBeenRead()) {
            this.runtime.redirectSubtree(new DefaultHandler(), "", "", "");
            return;
        }
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        switch (this.state) {
            case 1: {
                if (!uri.equals("http://schemas.xmlsoap.org/wsdl/") || !localName.equals("definitions")) break;
                this.runtime.onEnterElementConsumed(uri, localName, qname, atts);
                this.readDefinitionQName();
                this.state = 2;
                break;
            }
            case 2: {
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("types")) {
                    Types types = new Types(this, this._source, this.runtime, 90, this.expectedNamespace);
                    this.spawnChildFromEnterElement(types, uri, localName, qname, atts);
                    break;
                }
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("message")) {
                    Message message = new Message(this, this._source, this.runtime, 50, this.expectedNamespace);
                    this.spawnChildFromEnterElement(message, uri, localName, qname, atts);
                    break;
                }
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("portType")) {
                    PortType portType = new PortType(this, this._source, this.runtime, 60, this.expectedNamespace);
                    this.spawnChildFromEnterElement(portType, uri, localName, qname, atts);
                    break;
                }
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("binding")) {
                    BoundPortType boundPortType = new BoundPortType(this, this._source, this.runtime, 70, this.expectedNamespace);
                    this.spawnChildFromEnterElement(boundPortType, uri, localName, qname, atts);
                    break;
                }
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("service")) {
                    Service service = new Service(this, this._source, this.runtime, 80, this.expectedNamespace);
                    this.spawnChildFromEnterElement(service, uri, localName, qname, atts);
                    break;
                }
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("import")) {
                    String location;
                    String namespace = atts.getValue("namespace");
                    if (namespace == null) {
                        this.runtime.getErrorHandler().error(new SAXParseException(org.jvnet.wom.impl.parser.handler.Messages.format("wsdl.missingAttribute", "namespace", "wsdl:import"), this.runtime.getLocator()));
                    }
                    if ((location = atts.getValue("location")) == null) {
                        this.runtime.getErrorHandler().error(new SAXParseException(org.jvnet.wom.impl.parser.handler.Messages.format("wsdl.missingAttribute", "location", "wsdl:import"), this.runtime.getLocator()));
                    }
                    if (location == null || namespace == null) break;
                    this.runtime.importWSDL(namespace, location);
                    break;
                }
                super.enterElement(uri, localName, qname, atts);
                break;
            }
        }
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("definitions")) {
            this.endProcessingExtentionElement(this.runtime.currentWSDL);
            this.runtime.currentWSDL.setDocumentation(this.getWSDLDocumentation());
        }
    }

    public void text(String value) throws SAXException {
    }

    public void enterAttribute(String uri, String localName, String qname) throws SAXException {
    }

    public void leaveAttribute(String uri, String localName, String qname) throws SAXException {
    }
}

