/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericSniffer
implements Sniffer {
    @Inject
    protected ModulesRegistry modulesRegistry;
    private final String containerName;
    private final String appStigma;
    private final String urlPattern;

    public GenericSniffer(String containerName, String appStigma, String urlPattern) {
        this.containerName = containerName;
        this.appStigma = appStigma;
        this.urlPattern = urlPattern;
    }

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        if (this.appStigma != null) {
            try {
                if (location.exists(this.appStigma)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public String[] getURLPatterns() {
        if (this.urlPattern != null) {
            return new String[]{this.urlPattern};
        }
        return null;
    }

    public String getModuleType() {
        return this.containerName;
    }

    public Module[] setup(String containerHome, Logger logger) throws IOException {
        return null;
    }

    public void tearDown() {
    }

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[0];
    }

    public boolean isUserVisible() {
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof Sniffer) {
            Sniffer otherSniffer = (Sniffer)other;
            return this.getModuleType().equals(otherSniffer.getModuleType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDeploymentConfigurations(ReadableArchive location) throws IOException {
        HashMap<String, String> deploymentConfigs = new HashMap<String, String>();
        for (String path : this.getDeploymentConfigurationPaths()) {
            InputStream is = null;
            try {
                int bytesRead;
                is = location.getEntry(path);
                if (is == null) continue;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                deploymentConfigs.put(path, os.toString());
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return deploymentConfigs;
    }

    protected List<String> getDeploymentConfigurationPaths() {
        return Collections.EMPTY_LIST;
    }

    public String[] getIncompatibleSnifferTypes() {
        return new String[0];
    }
}

