/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class FileWrapper
implements Closeable {
    private final File file;
    private FileInputStream fis;
    private InputStreamReader isr;
    private BufferedReader reader;
    private FileOutputStream fos;
    private OutputStreamWriter osw;
    private BufferedWriter writer;
    private FileState state;

    public FileWrapper(File file) {
        this.file = file;
        this.fis = null;
        this.isr = null;
        this.reader = null;
        this.fos = null;
        this.osw = null;
        this.writer = null;
        this.state = FileState.CLOSED;
    }

    public FileWrapper(String str) {
        this(new File(str));
    }

    public FileWrapper(File root, String str) {
        this(new File(root, str));
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public String toString() {
        return this.file.toString();
    }

    boolean isYoungerThan(FileWrapper fw) {
        if (this.file.exists()) {
            return this.file.lastModified() < fw.file.lastModified();
        }
        return true;
    }

    public void delete() {
        this.file.delete();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsoluteName() {
        return this.file.getAbsolutePath();
    }

    public String readLine() throws IOException {
        if (this.state != FileState.OPEN_FOR_READ) {
            throw new IOException(this.file + " is not open for reading");
        }
        return this.reader.readLine();
    }

    public void writeLine(String line) throws IOException {
        if (this.state != FileState.OPEN_FOR_WRITE) {
            throw new IOException(this.file + " is not open for writing");
        }
        this.writer.write(line, 0, line.length());
        this.writer.newLine();
    }

    public void close() {
        try {
            if (this.state == FileState.OPEN_FOR_READ) {
                this.reader.close();
                this.isr.close();
                this.fis.close();
            } else if (this.state == FileState.OPEN_FOR_WRITE) {
                this.writer.close();
                this.osw.close();
                this.fos.close();
            }
            this.state = FileState.CLOSED;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void open(OpenMode mode) throws IOException {
        if (this.state == FileState.CLOSED) {
            if (mode == OpenMode.READ) {
                this.fis = new FileInputStream(this.file);
                this.isr = new InputStreamReader(this.fis);
                this.reader = new BufferedReader(this.isr);
                this.state = FileState.OPEN_FOR_READ;
            } else {
                this.fos = new FileOutputStream(this.file, true);
                this.osw = new OutputStreamWriter(this.fos);
                this.writer = new BufferedWriter(this.osw);
                this.state = FileState.OPEN_FOR_WRITE;
            }
        } else if (this.state == FileState.OPEN_FOR_READ) {
            if (mode != OpenMode.READ) {
                throw new IOException(this.file + " is already open for reading, cannot open for writing");
            }
        } else if (mode != OpenMode.WRITE) {
            throw new IOException(this.file + " is already open for writing, cannot open for reading");
        }
    }

    public FileState getFileState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(FileWrapper target, byte[] buffer) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(this.file);
            fos = new FileOutputStream(target.file);
            int dataRead = fis.read(buffer);
            while (dataRead > 0) {
                fos.write(buffer, 0, dataRead);
                dataRead = fis.read(buffer);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpenMode {
        READ,
        WRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileState {
        CLOSED,
        OPEN_FOR_READ,
        OPEN_FOR_WRITE;

    }
}

