/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.generic;

import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<E> {
    private Set<E> roots;
    private List<E> preorderTraversal = null;
    private List<E> postorderTraversal = null;

    private void traverse(E node, Set<E> visited, Finder<E> finder) {
        if (!visited.contains(node)) {
            visited.add(node);
            this.preorderTraversal.add(node);
            for (Object child : (List)finder.evaluate(node)) {
                this.traverse(child, visited, finder);
            }
            this.postorderTraversal.add(node);
        }
    }

    private void init(Collection<E> roots, Finder<E> finder) {
        this.roots = new HashSet<E>(roots);
        this.roots = Collections.unmodifiableSet(this.roots);
        this.preorderTraversal = new ArrayList();
        this.postorderTraversal = new ArrayList();
        HashSet visited = new HashSet();
        for (E node : this.roots) {
            this.traverse(node, visited, finder);
        }
        this.preorderTraversal = Collections.unmodifiableList(this.preorderTraversal);
        this.postorderTraversal = Collections.unmodifiableList(this.postorderTraversal);
    }

    public Graph(Collection<E> roots, Finder<E> finder) {
        this.init(roots, finder);
    }

    public Graph(E root, Finder<E> finder) {
        HashSet<E> roots = new HashSet<E>();
        roots.add(root);
        this.init(roots, finder);
    }

    public Set<E> getRoots() {
        return this.roots;
    }

    public List<E> getPreorderList() {
        return this.preorderTraversal;
    }

    public List<E> getPostorderList() {
        return this.postorderTraversal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Finder<E>
    extends UnaryFunction<E, List<E>> {
    }
}

