/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.SnifferAnnotationScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.glassfish.api.container.CompositeSniffer;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SnifferManagerImpl
implements SnifferManager {
    volatile List<Sniffer> sniffers;
    volatile List<CompositeSniffer> compositeSniffers;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SnifferManagerImpl.class);
    @Inject
    protected Habitat habitat;

    public Collection<Sniffer> getSniffers() {
        if (this.sniffers == null) {
            this.sniffers = new ArrayList<Sniffer>();
            this.sniffers.addAll(this.habitat.getAllByContract(Sniffer.class));
            Collections.sort(this.sniffers, new Comparator<Sniffer>(){

                @Override
                public int compare(Sniffer o1, Sniffer o2) {
                    return o1.getModuleType().compareTo(o2.getModuleType());
                }
            });
        }
        return this.sniffers;
    }

    public Collection<CompositeSniffer> getCompositeSniffers() {
        if (this.compositeSniffers == null) {
            this.compositeSniffers = new ArrayList<CompositeSniffer>();
            this.compositeSniffers.addAll(this.habitat.getAllByContract(CompositeSniffer.class));
        }
        return this.compositeSniffers;
    }

    public final boolean hasNoSniffers() {
        return this.getSniffers().isEmpty();
    }

    public Sniffer getSniffer(String appType) {
        assert (appType != null);
        for (Sniffer sniffer : this.getSniffers()) {
            if (!appType.equalsIgnoreCase(sniffer.getModuleType())) continue;
            return sniffer;
        }
        return null;
    }

    public Collection<Sniffer> getSniffers(ReadableArchive archive, ClassLoader cloader) {
        ArrayList<Sniffer> appSniffers = new ArrayList<Sniffer>();
        SnifferAnnotationScanner snifferAnnotationScanner = new SnifferAnnotationScanner();
        for (Sniffer sniffer : this.getSniffers()) {
            if (sniffer instanceof CompositeSniffer) continue;
            snifferAnnotationScanner.register(sniffer, sniffer.getAnnotationTypes());
        }
        snifferAnnotationScanner.scanArchive(archive);
        appSniffers.addAll(snifferAnnotationScanner.getApplicableSniffers());
        for (Sniffer sniffer : this.getSniffers()) {
            if (sniffer instanceof CompositeSniffer || appSniffers.contains(sniffer) || !sniffer.handles(archive, cloader)) continue;
            appSniffers.add(sniffer);
        }
        return appSniffers;
    }

    public boolean canBeIsolated(Sniffer sniffer) {
        return sniffer.getModuleType().equalsIgnoreCase("osgi");
    }

    public Collection<Sniffer> getCompositeSniffers(DeploymentContext context) {
        ArrayList<Sniffer> appSniffers = new ArrayList<Sniffer>();
        SnifferAnnotationScanner snifferAnnotationScanner = new SnifferAnnotationScanner();
        for (CompositeSniffer sniffer : this.getCompositeSniffers()) {
            snifferAnnotationScanner.register((Sniffer)sniffer, sniffer.getAnnotationTypes());
        }
        snifferAnnotationScanner.scanArchive(context.getSource());
        appSniffers.addAll(snifferAnnotationScanner.getApplicableSniffers());
        for (CompositeSniffer sniffer : this.getCompositeSniffers()) {
            if (appSniffers.contains(sniffer) || !sniffer.handles(context)) continue;
            appSniffers.add((Sniffer)sniffer);
        }
        return appSniffers;
    }

    public void validateSniffers(Collection<Sniffer> snifferCol, DeploymentContext context) {
        for (Sniffer sniffer : snifferCol) {
            String[] incompatTypes;
            for (String type : incompatTypes = sniffer.getIncompatibleSnifferTypes()) {
                for (Sniffer sniffer2 : snifferCol) {
                    if (!sniffer2.getModuleType().equals(type)) continue;
                    throw new IllegalArgumentException(localStrings.getLocalString("invalidarchivepackaging", "Invalid archive packaging {2}", new Object[]{sniffer.getModuleType(), type, context.getSourceDir().getPath()}));
                }
            }
        }
    }
}

