/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.deployment;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WSDolSupport;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceClient;
import org.jvnet.hk2.annotations.Service;

@Service
public class WSDolSupportImpl
implements WSDolSupport {
    public static final String SOAP11_TOKEN = "##SOAP11_HTTP";
    public static final String SOAP12_TOKEN = "##SOAP12_HTTP";
    public static final String SOAP11_MTOM_TOKEN = "##SOAP11_HTTP_MTOM";
    public static final String SOAP12_MTOM_TOKEN = "##SOAP12_HTTP_MTOM";
    public static final String XML_TOKEN = "##XML_HTTP";

    public String getProtocolBinding(String value) {
        if (value == null) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (SOAP11_TOKEN.equals(value)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (SOAP11_MTOM_TOKEN.equals(value)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true";
        }
        if (SOAP12_TOKEN.equals(value)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        if (SOAP12_MTOM_TOKEN.equals(value)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true";
        }
        if (XML_TOKEN.equals(value)) {
            return "http://www.w3.org/2004/08/wsdl/http";
        }
        return value;
    }

    public String getSoapAddressPrefix(String protocolBinding) {
        if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(protocolBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(protocolBinding) || SOAP12_TOKEN.equals(protocolBinding) || SOAP12_MTOM_TOKEN.equals(protocolBinding)) {
            return "soap12";
        }
        return "soap";
    }

    public void setServiceRef(Class annotatedClass, ServiceReferenceDescriptor ref) {
        WebServiceClient wsc = annotatedClass.getAnnotation(WebServiceClient.class);
        if (wsc != null) {
            ref.setWsdlFileUri(wsc.wsdlLocation());
            ref.setServiceName(new QName(wsc.targetNamespace(), wsc.name()));
        }
    }

    public Class getType(String className) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(className);
    }
}

