/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.single;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyModuleDefinition
implements ModuleDefinition {
    private final ModuleMetadata metadata = new ModuleMetadata();
    private final Manifest manifest = new Manifest();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ModuleDependency[] EMPTY_MODULE_DEFINITIONS_ARRAY = new ModuleDependency[0];
    private static final URI[] EMPTY_URI_ARRAY = new URI[0];

    public ProxyModuleDefinition(ClassLoader classLoader) throws IOException {
        this(classLoader, Collections.singleton("default"));
    }

    public ProxyModuleDefinition(ClassLoader classLoader, Collection<String> habitatNames) throws IOException {
        for (String habitatName : habitatNames) {
            Enumeration<URL> inhabitants = classLoader.getResources("META-INF/inhabitants/" + habitatName);
            while (inhabitants.hasMoreElements()) {
                URL url = inhabitants.nextElement();
                this.metadata.addHabitat(habitatName, new ModuleMetadata.InhabitantsDescriptor(url, ProxyModuleDefinition.readFully(url)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFully(URL url) throws IOException {
        try {
            URLConnection con = url.openConnection();
            int len = con.getContentLength();
            InputStream in = con.getInputStream();
            try {
                if (len < 0) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while (true) {
                        int sz;
                        if ((sz = in.read(buf)) < 0) {
                            byte[] byArray = baos.toByteArray();
                            return byArray;
                        }
                        baos.write(buf, 0, sz);
                    }
                }
                byte[] r = new byte[len];
                new DataInputStream(in).readFully(r);
                byte[] byArray = r;
                return byArray;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            IOException x = new IOException("Failed to read " + url);
            x.initCause(e);
            throw x;
        }
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public String[] getPublicInterfaces() {
        return null;
    }

    @Override
    public ModuleDependency[] getDependencies() {
        return EMPTY_MODULE_DEFINITIONS_ARRAY;
    }

    @Override
    public URI[] getLocations() {
        return EMPTY_URI_ARRAY;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getImportPolicyClassName() {
        return null;
    }

    @Override
    public String getLifecyclePolicyClassName() {
        return null;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public ModuleMetadata getMetadata() {
        return this.metadata;
    }
}

