/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.sql.Timestamp;
import java.util.Vector;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ModifyQuery;

public class TimestampLockingPolicy
extends VersionLockingPolicy {
    protected int retrieveTimeFrom;
    public static final int SERVER_TIME = 1;
    public static final int LOCAL_TIME = 2;

    public TimestampLockingPolicy() {
        this.useServerTime();
    }

    public TimestampLockingPolicy(String string) {
        super(string);
        this.useServerTime();
    }

    public TimestampLockingPolicy(DatabaseField databaseField) {
        super(databaseField);
        this.useServerTime();
    }

    public int compareWriteLockValues(Object object, Object object2) {
        Timestamp timestamp = (Timestamp)object;
        Timestamp timestamp2 = (Timestamp)object2;
        return timestamp.compareTo(timestamp2);
    }

    protected Class getDefaultLockingFieldType() {
        return ClassConstants.TIMESTAMP;
    }

    public Object getBaseValue() {
        return new Timestamp(0L);
    }

    protected Object getInitialWriteValue(AbstractSession abstractSession) {
        if (this.usesLocalTime()) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.usesServerTime()) {
            AbstractSession abstractSession2 = abstractSession.getSessionForClass(this.getDescriptor().getJavaClass());
            while (abstractSession2.isUnitOfWork()) {
                abstractSession2 = ((UnitOfWorkImpl)abstractSession2).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            return abstractSession2.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(abstractSession, abstractSession2.getName());
        }
        return null;
    }

    public Object getNewLockValue(ModifyQuery modifyQuery) {
        return this.getInitialWriteValue(modifyQuery.getSession());
    }

    public Object getValueToPutInCache(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isStoredInCache()) {
            return abstractSession.getDatasourcePlatform().convertObject(abstractRecord.get(this.getWriteLockField()), ClassConstants.TIMESTAMP);
        }
        return null;
    }

    public int getVersionDifference(Object object, Object object2, Vector vector, AbstractSession abstractSession) {
        Timestamp timestamp = (Timestamp)object;
        if (timestamp == null) {
            return 0;
        }
        Timestamp timestamp2 = this.isStoredInCache() ? (Timestamp)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, object2.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(object2);
        if (timestamp2 != null && !timestamp.after(timestamp2)) {
            return 0;
        }
        return 2;
    }

    public Object getWriteLockValue(Object object, Vector vector, AbstractSession abstractSession) {
        Timestamp timestamp = null;
        if (this.isStoredInCache()) {
            timestamp = (Timestamp)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor());
        } else {
            Object object2 = this.lockValueFromObject(object);
            if (object2 != null) {
                if (object2 instanceof Timestamp) {
                    timestamp = (Timestamp)this.lockValueFromObject(object);
                } else {
                    throw OptimisticLockException.needToMapJavaSqlTimestampWhenStoredInObject();
                }
            }
        }
        return timestamp;
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder expressionBuilder, AbstractSession abstractSession) {
        return expressionBuilder.value(this.getInitialWriteValue(abstractSession));
    }

    protected Number incrementWriteLockValue(Number number) {
        return null;
    }

    public boolean isChildWriteLockValueGreater(AbstractSession abstractSession, Vector vector, Class clazz, ObjectChangeSet objectChangeSet) {
        if (this.isStoredInCache()) {
            Timestamp timestamp = (Timestamp)objectChangeSet.getWriteLockValue();
            Timestamp timestamp2 = (Timestamp)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, this.getDescriptor());
            if (timestamp != null && (timestamp2 == null || timestamp2.before(timestamp))) {
                return true;
            }
        }
        return false;
    }

    public boolean isNewerVersion(Object object, Object object2, Vector vector, AbstractSession abstractSession) {
        Timestamp timestamp = (Timestamp)object;
        Timestamp timestamp2 = this.isStoredInCache() ? (Timestamp)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, object2.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(object2);
        if (timestamp2 == null) {
            return false;
        }
        if (timestamp == null) {
            return true;
        }
        return timestamp.after(timestamp2);
    }

    public boolean isNewerVersion(AbstractRecord abstractRecord, Object object, Vector vector, AbstractSession abstractSession) {
        Timestamp timestamp = (Timestamp)abstractSession.getDatasourcePlatform().convertObject(abstractRecord.get(this.getWriteLockField()), ClassConstants.TIMESTAMP);
        Timestamp timestamp2 = this.isStoredInCache() ? (Timestamp)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(object);
        if (timestamp2 == null) {
            return false;
        }
        if (timestamp == null) {
            return true;
        }
        return timestamp.after(timestamp2);
    }

    public void setUsesServerTime(boolean bl) {
        if (bl) {
            this.useServerTime();
        } else {
            this.useLocalTime();
        }
    }

    public void useLocalTime() {
        this.retrieveTimeFrom = 2;
    }

    public void useServerTime() {
        this.retrieveTimeFrom = 1;
    }

    public boolean usesLocalTime() {
        return this.retrieveTimeFrom == 2;
    }

    public boolean usesServerTime() {
        return this.retrieveTimeFrom == 1;
    }
}

