/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.eis.mappings.EISDirectMapping;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.QNameInheritancePolicy;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class EISDescriptor
extends ClassDescriptor {
    protected String dataFormat;
    public static final String MAPPED = "mapped";
    public static final String INDEXED = "indexed";
    public static final String XML = "xml";
    protected NamespaceResolver namespaceResolver;

    public EISDescriptor() {
        this.shouldOrderMappings = false;
        this.dataFormat = XML;
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
        if (!databaseMapping.isEISMapping()) {
            throw DescriptorException.invalidMappingType(databaseMapping);
        }
    }

    public void setDataTypeName(String string) throws DescriptorException {
        this.setTableName(string);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            if (this.getDataFormat() == XML) {
                this.setInheritancePolicy(new QNameInheritancePolicy(this));
            } else {
                this.setInheritancePolicy(new InheritancePolicy(this));
            }
        }
        return this.inheritancePolicy;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setQueryManager(DescriptorQueryManager descriptorQueryManager) {
        this.queryManager = descriptorQueryManager;
        if (descriptorQueryManager != null) {
            descriptorQueryManager.setDescriptor(this);
        }
    }

    public void preInitialize(AbstractSession abstractSession) {
        if (this.isInitialized(1)) {
            return;
        }
        if (this.dataFormat.equals(XML)) {
            this.setObjectBuilder(new XMLObjectBuilder(this));
            if (this.hasInheritance()) {
                ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.namespaceResolver);
            }
        }
        super.preInitialize(abstractSession);
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getDataTypeName() throws DescriptorException {
        return this.getTableName();
    }

    public void setDataFormat(String string) {
        this.dataFormat = string;
    }

    public void useMappedRecordFormat() {
        this.setDataFormat(MAPPED);
    }

    public void useIndexedRecordFormat() {
        this.setDataFormat(INDEXED);
    }

    public void useXMLRecordFormat() {
        this.setDataFormat(XML);
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object object) {
        if (!this.getDataFormat().equals(XML)) {
            if (!(object instanceof List)) {
                return new DatabaseRecord(1);
            }
            List list = (List)object;
            if (list.isEmpty()) {
                return new DatabaseRecord(1);
            }
            if (!(list.get(0) instanceof AbstractRecord)) {
                return new DatabaseRecord(1);
            }
            return (AbstractRecord)list.get(0);
        }
        if (object instanceof XMLRecord) {
            return (XMLRecord)object;
        }
        if (!(object instanceof Vector)) {
            return this.getObjectBuilder().createRecord(null);
        }
        Vector vector = (Vector)object;
        if (vector.isEmpty()) {
            return this.getObjectBuilder().createRecord(null);
        }
        if (!(vector.firstElement() instanceof XMLRecord)) {
            return this.getObjectBuilder().createRecord(null);
        }
        return (XMLRecord)vector.firstElement();
    }

    public Vector buildNestedRowsFromFieldValue(Object object, AbstractSession abstractSession) {
        if (!this.getDataFormat().equals(XML)) {
            if (!(object instanceof List)) {
                return new Vector();
            }
            return new Vector((List)object);
        }
        if (!(object instanceof Vector)) {
            return new Vector(0);
        }
        return (Vector)object;
    }

    public Vector buildDirectValuesFromFieldValue(Object object) {
        if (!this.getDataFormat().equals(XML)) {
            return super.buildDirectValuesFromFieldValue(object);
        }
        if (!(object instanceof Vector)) {
            Vector<Object> vector = new Vector<Object>(1);
            vector.add(object);
            return vector;
        }
        return (Vector)object;
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, AbstractSession abstractSession) {
        if (!this.getDataFormat().equals(XML)) {
            return super.buildFieldValueFromDirectValues(vector, string, abstractSession);
        }
        return vector;
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord abstractRecord, AbstractSession abstractSession) throws DatabaseException {
        Vector<AbstractRecord> vector = new Vector<AbstractRecord>(1);
        vector.addElement(abstractRecord);
        return this.buildFieldValueFromNestedRows(vector, "", abstractSession);
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, AbstractSession abstractSession) throws DatabaseException {
        return vector;
    }

    public DatabaseField buildField(String string) {
        if (this.getDataFormat().equals(XML)) {
            XMLField xMLField = new XMLField(string);
            xMLField.setNamespaceResolver(this.getNamespaceResolver());
            return xMLField;
        }
        return super.buildField(string);
    }

    public DatabaseField buildField(DatabaseField databaseField) {
        if (databaseField instanceof XMLField) {
            ((XMLField)databaseField).setNamespaceResolver(this.getNamespaceResolver());
        }
        return super.buildField(databaseField);
    }

    public DatabaseMapping addDirectMapping(String string, String string2) {
        EISDirectMapping eISDirectMapping = new EISDirectMapping();
        eISDirectMapping.setAttributeName(string);
        if (this.getDataFormat() == XML) {
            eISDirectMapping.setXPath(string2);
        } else {
            eISDirectMapping.setFieldName(string2);
        }
        return this.addMapping(eISDirectMapping);
    }

    public DatabaseMapping addDirectMapping(String string, String string2, String string3, String string4) {
        EISDirectMapping eISDirectMapping = new EISDirectMapping();
        eISDirectMapping.setAttributeName(string);
        eISDirectMapping.setSetMethodName(string3);
        eISDirectMapping.setGetMethodName(string2);
        if (this.getDataFormat() == XML) {
            eISDirectMapping.setXPath(string4);
        } else {
            eISDirectMapping.setFieldName(string4);
        }
        return this.addMapping(eISDirectMapping);
    }

    public void addPrimaryKeyFieldName(String string) {
        super.addPrimaryKeyFieldName(string);
    }

    public void setSequenceNumberFieldName(String string) {
        super.setSequenceNumberFieldName(string);
    }

    public DatabaseCall buildCallFromStatement(SQLStatement sQLStatement, AbstractSession abstractSession) {
        throw QueryException.noCallOrInteractionSpecified();
    }

    public void initializeAggregateInheritancePolicy(AbstractSession abstractSession) {
    }

    public boolean requiresInitialization() {
        return !this.isDescriptorForInterface();
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return false;
    }

    public boolean shouldUseFullChangeSetsForNewObjects() {
        return true;
    }
}

