/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Session;

public class EISLogin
extends DatasourceLogin {
    public EISLogin() {
        this(new EISPlatform());
    }

    public EISLogin(Platform platform) {
        super(platform);
        this.connector = new EISConnectionSpec();
    }

    public Accessor buildAccessor() {
        return new EISAccessor();
    }

    public Object connectToDatasource(Accessor accessor, Session session) {
        return this.getConnectionSpec().connectToDataSource((EISAccessor)accessor, this.getProperties());
    }

    public void setPassword(String string) {
        if (string != null) {
            this.setProperty("password", string.toCharArray());
        } else {
            this.removeProperty("password");
        }
    }

    public String getConnectionFactoryURL() {
        if (this.getConnectionSpec().getName() == null || this.getConnectionSpec().getName().size() == 0) {
            return null;
        }
        return this.getConnectionSpec().getName().get(0);
    }

    public void setConnectionFactoryURL(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.getConnectionSpec().setName(string);
    }

    public EISConnectionSpec getConnectionSpec() {
        return (EISConnectionSpec)this.getConnector();
    }

    public void setConnectionSpec(EISConnectionSpec eISConnectionSpec) {
        this.setConnector(eISConnectionSpec);
    }

    public void configureConnectionSpec(String string) {
        this.setConnectionSpec(new EISConnectionSpec(string));
    }

    public void configureConnectionSpec(ConnectionFactory connectionFactory) {
        EISConnectionSpec eISConnectionSpec = new EISConnectionSpec();
        eISConnectionSpec.setConnectionFactory(connectionFactory);
        this.setConnectionSpec(eISConnectionSpec);
    }

    public void configureConnectionSpec(String string, ConnectionSpec connectionSpec) {
        EISConnectionSpec eISConnectionSpec = new EISConnectionSpec(string);
        eISConnectionSpec.setConnectionSpec(connectionSpec);
        this.setConnectionSpec(eISConnectionSpec);
    }

    public void configureConnectionSpec(ConnectionFactory connectionFactory, ConnectionSpec connectionSpec) {
        EISConnectionSpec eISConnectionSpec = new EISConnectionSpec();
        eISConnectionSpec.setConnectionFactory(connectionFactory);
        eISConnectionSpec.setConnectionSpec(connectionSpec);
        this.setConnectionSpec(eISConnectionSpec);
    }
}

