/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.RecordConverter;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.queries.Call;
import org.w3c.dom.Element;

public class EISPlatform
extends DatasourcePlatform {
    protected boolean isIndexedRecordSupported;
    protected boolean isMappedRecordSupported;
    protected boolean isDOMRecordSupported;
    protected boolean shouldConvertDataToStrings;
    protected boolean supportsLocalTransactions;
    protected boolean requiresAutoCommit;
    protected RecordConverter recordConverter;
    protected Method domMethod;
    protected XMLConversionManager xmlConversionManager;

    public EISPlatform() {
        this.setIsMappedRecordSupported(true);
        this.setIsIndexedRecordSupported(true);
        this.setIsDOMRecordSupported(false);
        this.setShouldConvertDataToStrings(false);
        this.setSupportsLocalTransactions(true);
        this.setRequiresAutoCommit(false);
    }

    public RecordConverter getRecordConverter() {
        return this.recordConverter;
    }

    public void setRecordConverter(RecordConverter recordConverter) {
        this.recordConverter = recordConverter;
    }

    public boolean requiresAutoCommit() {
        return this.requiresAutoCommit;
    }

    public void setRequiresAutoCommit(boolean bl) {
        this.requiresAutoCommit = bl;
    }

    public boolean supportsLocalTransactions() {
        return this.supportsLocalTransactions;
    }

    public void setSupportsLocalTransactions(boolean bl) {
        this.supportsLocalTransactions = bl;
    }

    public boolean isIndexedRecordSupported() {
        return this.isIndexedRecordSupported;
    }

    public void setIsIndexedRecordSupported(boolean bl) {
        this.isIndexedRecordSupported = bl;
    }

    public boolean isMappedRecordSupported() {
        return this.isMappedRecordSupported;
    }

    public void setIsMappedRecordSupported(boolean bl) {
        this.isMappedRecordSupported = bl;
    }

    public boolean isDOMRecordSupported() {
        return this.isDOMRecordSupported;
    }

    public void setIsDOMRecordSupported(boolean bl) {
        this.isDOMRecordSupported = bl;
    }

    public boolean shouldConvertDataToStrings() {
        return this.shouldConvertDataToStrings;
    }

    public void setShouldConvertDataToStrings(boolean bl) {
        this.shouldConvertDataToStrings = bl;
    }

    public InteractionSpec buildInteractionSpec(EISInteraction eISInteraction) {
        return eISInteraction.getInteractionSpec();
    }

    public Record createInputRecord(EISInteraction eISInteraction, EISAccessor eISAccessor) {
        Record record = eISInteraction.createInputRecord(eISAccessor);
        if (this.getRecordConverter() != null) {
            record = this.getRecordConverter().converterToAdapterRecord(record);
        }
        return record;
    }

    public Record createOutputRecord(EISInteraction eISInteraction, EISAccessor eISAccessor) {
        return null;
    }

    public AbstractRecord buildRow(Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        Record record2 = record;
        if (this.getRecordConverter() != null) {
            record2 = this.getRecordConverter().converterFromAdapterRecord(record2);
        }
        return eISInteraction.buildRow(record2, eISAccessor);
    }

    public Vector buildRows(Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        Record record2 = record;
        if (this.getRecordConverter() != null) {
            record2 = this.getRecordConverter().converterFromAdapterRecord(record2);
        }
        return eISInteraction.buildRows(record2, eISAccessor);
    }

    public Record createDOMRecord(String string, EISAccessor eISAccessor) {
        try {
            return eISAccessor.getRecordFactory().createMappedRecord(string);
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, eISAccessor, null);
        }
    }

    public AbstractRecord createDatabaseRowFromDOMRecord(Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        return new EISDOMRecord(record);
    }

    public Object getValueFromRecord(String string, MappedRecord mappedRecord, EISAccessor eISAccessor) {
        return mappedRecord.get((Object)string);
    }

    public void setDOMInRecord(Element element, Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        block10: {
            Object[] objectArray;
            if (this.domMethod == null) {
                objectArray = new Class[]{Element.class};
                try {
                    this.domMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetMethod(record.getClass(), "setDom", (Class[])objectArray, false)) : PrivilegedAccessHelper.getMethod(record.getClass(), "setDom", (Class[])objectArray, false);
                }
                catch (Exception exception) {
                    try {
                        this.domMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetMethod(record.getClass(), "setDOM", (Class[])objectArray, false)) : PrivilegedAccessHelper.getMethod(record.getClass(), "setDOM", (Class[])objectArray, false);
                    }
                    catch (Exception exception2) {
                        throw new EISException(exception2);
                    }
                }
            }
            try {
                objectArray = new Object[]{element};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(this.domMethod, record, objectArray));
                        break block10;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (Exception)privilegedActionException.getCause();
                    }
                }
                PrivilegedAccessHelper.invokeMethod(this.domMethod, record, objectArray);
            }
            catch (Exception exception) {
                throw new EISException(exception);
            }
        }
    }

    public void setValueInRecord(String string, Object object, MappedRecord mappedRecord, EISAccessor eISAccessor) {
        Object object2 = object;
        if (this.shouldConvertDataToStrings()) {
            object2 = this.getConversionManager().convertObject(object, ClassConstants.STRING);
        }
        mappedRecord.put((Object)string, object2);
    }

    public void appendParameter(Call call, Writer writer, Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                this.appendParameter(call, writer, vector.elementAt(i));
            }
        } else if (object instanceof DOMRecord) {
            String string = ((DOMRecord)object).transformToXML();
            int n = string.indexOf(62);
            string = string.substring(n + 1, string.length());
            try {
                writer.write(string);
            }
            catch (IOException iOException) {
                throw ValidationException.fileError(iOException);
            }
        } else {
            super.appendParameter(call, writer, object);
        }
    }

    public ConversionManager getConversionManager() {
        if (this.isDOMRecordSupported()) {
            if (this.xmlConversionManager == null) {
                this.xmlConversionManager = (XMLConversionManager)XMLConversionManager.getDefaultXMLManager().clone();
            }
            return this.xmlConversionManager;
        }
        return super.getConversionManager();
    }
}

