/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.helper.Helper;

public class IntegrityException
extends ValidationException {
    protected IntegrityChecker integrityChecker;

    public IntegrityException() {
    }

    public IntegrityException(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public IntegrityChecker getIntegrityChecker() {
        return this.integrityChecker;
    }

    public String getMessage() {
        Exception exception;
        String string = Helper.cr();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(string + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        printWriter.println("---------------------------------------------------------");
        Enumeration enumeration = this.getIntegrityChecker().getCaughtExceptions().elements();
        while (enumeration.hasMoreElements()) {
            exception = (Exception)enumeration.nextElement();
            if (!(exception instanceof DescriptorException)) continue;
            printWriter.println(string + exception);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            printWriter.println(string + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            printWriter.println("---------------------------------------------------------");
            enumeration = this.getIntegrityChecker().getCaughtExceptions().elements();
            while (enumeration.hasMoreElements()) {
                exception = (Exception)enumeration.nextElement();
                if (exception instanceof DescriptorException) continue;
                printWriter.println(string + exception);
            }
        }
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        Exception exception;
        super.printStackTrace(printWriter);
        String string = Helper.cr();
        printWriter.println(string + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        printWriter.println("---------------------------------------------------------");
        Enumeration enumeration = this.getIntegrityChecker().getCaughtExceptions().elements();
        while (enumeration.hasMoreElements()) {
            exception = (Exception)enumeration.nextElement();
            if (!(exception instanceof DescriptorException)) continue;
            printWriter.println(string);
            exception.printStackTrace(printWriter);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            printWriter.println(string + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            printWriter.println("---------------------------------------------------------");
            enumeration = this.getIntegrityChecker().getCaughtExceptions().elements();
            while (enumeration.hasMoreElements()) {
                exception = (Exception)enumeration.nextElement();
                if (exception instanceof DescriptorException) continue;
                printWriter.println(string);
                exception.printStackTrace(printWriter);
            }
        }
        printWriter.flush();
    }
}

