/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;

public class IndirectList
extends Vector
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Vector delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    private transient List addedElements;
    private transient List removedElements;
    protected int initialCapacity;
    protected boolean isRegistered;

    public IndirectList() {
        this(10);
    }

    public IndirectList(int n) {
        this(n, 0);
    }

    public IndirectList(int n, int n2) {
        super(0);
        this.initialCapacity = n;
        this.capacityIncrement = n2;
    }

    public IndirectList(Collection collection) {
        super(0);
        this.valueHolder = new ValueHolder(new Vector(collection));
    }

    public void add(int n, Object object) {
        this.getDelegate().add(n, object);
        this.raiseAddChangeEvent(object, n);
    }

    protected void raiseAddChangeEvent(Object object, Integer n) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTrackedAttributeName(), this, object, CollectionChangeEvent.ADD, n));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(object, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object object, Integer n) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTrackedAttributeName(), this, object, CollectionChangeEvent.REMOVE, n));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(object);
        }
    }

    public boolean add(Object object) {
        if (!this.isRegistered) {
            return this.getDelegate().add(object);
        }
        boolean bl = true;
        if (this.shouldAvoidInstantiation()) {
            if (this.hasRemovedElements() && this.getRemovedElements().contains(object)) {
                this.getRemovedElements().remove(object);
            } else {
                if (this.getAddedElements().contains(object)) {
                    return false;
                }
                this.getAddedElements().add(object);
            }
        } else {
            bl = this.getDelegate().add(object);
        }
        this.raiseAddChangeEvent(object, null);
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        Iterator iterator = collection.iterator();
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            while (iterator.hasNext()) {
                this.add(n, iterator.next());
                ++n;
            }
            return true;
        }
        return this.getDelegate().addAll(n, collection);
    }

    public boolean addAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
            return true;
        }
        return this.getDelegate().addAll(collection);
    }

    public void addElement(Object object) {
        this.add(object);
    }

    protected Vector buildDelegate() {
        int n;
        int n2;
        Vector vector = (Vector)this.getValueHolder().getValue();
        if (vector == null) {
            vector = new Vector(this.initialCapacity, this.capacityIncrement);
        }
        while (vector instanceof IndirectList) {
            vector = ((IndirectList)vector).getDelegate();
        }
        if (this.hasAddedElements()) {
            n2 = this.getAddedElements().size();
            for (n = 0; n < n2; ++n) {
                Object e = ((List)this.getAddedElements()).get(n);
                if (vector.contains(e)) continue;
                vector.add(e);
            }
            this.addedElements = null;
        }
        if (this.hasRemovedElements()) {
            n2 = this.getRemovedElements().size();
            for (n = 0; n < n2; ++n) {
                vector.remove(((List)this.getRemovedElements()).get(n));
            }
            this.removedElements = null;
        }
        return vector;
    }

    public int capacity() {
        return this.getDelegate().capacity();
    }

    public void clear() {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                iterator.remove();
                this.raiseRemoveChangeEvent(e, null);
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public synchronized Object clone() {
        IndirectList indirectList = (IndirectList)super.clone();
        indirectList.delegate = (Vector)this.getDelegate().clone();
        indirectList.attributeName = null;
        indirectList.changeListener = null;
        return indirectList;
    }

    public boolean contains(Object object) {
        if (this.hasAddedElements() && this.getAddedElements().contains(object)) {
            return true;
        }
        if (this.hasRemovedElements() && this.getRemovedElements().contains(object)) {
            return false;
        }
        return this.getDelegate().contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.getDelegate().containsAll(collection);
    }

    public synchronized void copyInto(Object[] objectArray) {
        this.getDelegate().copyInto(objectArray);
    }

    public Object elementAt(int n) {
        return this.getDelegate().elementAt(n);
    }

    public Enumeration elements() {
        return this.getDelegate().elements();
    }

    public void ensureCapacity(int n) {
        this.getDelegate().ensureCapacity(n);
    }

    public boolean equals(Object object) {
        return this.getDelegate().equals(object);
    }

    public Object firstElement() {
        return this.getDelegate().firstElement();
    }

    public Object get(int n) {
        return this.getDelegate().get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getDelegate() {
        if (this.delegate == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    public Object getDelegateObject() {
        return this.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Vector(this.initialCapacity, this.capacityIncrement));
                }
            }
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public int indexOf(Object object) {
        return this.getDelegate().indexOf(object);
    }

    public int indexOf(Object object, int n) {
        return this.getDelegate().indexOf(object, n);
    }

    public void insertElementAt(Object object, int n) {
        this.getDelegate().insertElementAt(object, n);
        this.raiseAddChangeEvent(object, new Integer(n));
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public Object lastElement() {
        return this.getDelegate().lastElement();
    }

    public int lastIndexOf(Object object) {
        return this.getDelegate().lastIndexOf(object);
    }

    public int lastIndexOf(Object object, int n) {
        return this.getDelegate().lastIndexOf(object, n);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int n) {
        return new ListIterator(){
            ListIterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().listIterator(n);
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public Object previous() {
                this.currentObject = this.delegateIterator.previous();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject, new Integer(this.delegateIterator.nextIndex()));
            }

            public void set(Object object) {
                this.delegateIterator.set(object);
                Integer n2 = new Integer(this.delegateIterator.previousIndex());
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject, n2);
                IndirectList.this.raiseAddChangeEvent(object, n2);
            }

            public void add(Object object) {
                this.delegateIterator.add(object);
                IndirectList.this.raiseAddChangeEvent(object, new Integer(this.delegateIterator.previousIndex()));
            }
        };
    }

    public Object remove(int n) {
        Object e = this.getDelegate().remove(n);
        this.raiseRemoveChangeEvent(e, new Integer(n));
        return e;
    }

    public boolean remove(Object object) {
        if (!this.isRegistered) {
            return this.getDelegate().remove(object);
        }
        if (this.shouldAvoidInstantiation()) {
            if (this.hasAddedElements() && this.getAddedElements().contains(object)) {
                this.getAddedElements().remove(object);
            } else {
                if (this.getRemovedElements().contains(object)) {
                    return false;
                }
                this.getRemovedElements().add(object);
            }
            this.raiseRemoveChangeEvent(object, null);
            return true;
        }
        if (this.getDelegate().remove(object)) {
            this.raiseRemoveChangeEvent(object, null);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return true;
        }
        return this.getDelegate().removeAll(collection);
    }

    public void removeAllElements() {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                iterator.remove();
                this.raiseRemoveChangeEvent(e, null);
            }
            return;
        }
        this.getDelegate().removeAllElements();
    }

    public boolean removeElement(Object object) {
        return this.remove(object);
    }

    public void removeElementAt(int n) {
        this.remove(n);
    }

    public boolean retainAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator iterator = this.getDelegate().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (collection.contains(e)) continue;
                iterator.remove();
                this.raiseRemoveChangeEvent(e, null);
            }
            return true;
        }
        return this.getDelegate().retainAll(collection);
    }

    public Object set(int n, Object object) {
        Object object2 = this.getDelegate().set(n, object);
        Integer n2 = new Integer(n);
        this.raiseRemoveChangeEvent(object2, n2);
        this.raiseAddChangeEvent(object, n2);
        return object2;
    }

    public void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public void setSize(int n) {
        if ((this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) && n > this.size()) {
            for (int i = this.size(); i > n; --i) {
                this.remove(i - 1);
            }
        }
        this.getDelegate().setSize(n);
    }

    public void setValueHolder(ValueHolderInterface valueHolderInterface) {
        this.delegate = null;
        this.valueHolder = valueHolderInterface;
        if (valueHolderInterface instanceof UnitOfWorkQueryValueHolder) {
            this.isRegistered = true;
        }
    }

    public int size() {
        return this.getDelegate().size();
    }

    public List subList(int n, int n2) {
        return this.getDelegate().subList(n, n2);
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getDelegate().toArray(objectArray);
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public void trimToSize() {
        this.getDelegate().trimToSize();
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
        if (propertyChangeListener != null) {
            this.isRegistered = true;
        }
    }

    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    public void setTrackedAttributeName(String string) {
        this.attributeName = string;
    }

    public Collection getRemovedElements() {
        if (this.removedElements == null) {
            this.removedElements = new ArrayList();
        }
        return this.removedElements;
    }

    public Collection getAddedElements() {
        if (this.addedElements == null) {
            this.addedElements = new ArrayList();
        }
        return this.addedElements;
    }

    public boolean hasAddedElements() {
        return this.addedElements != null && !this.addedElements.isEmpty();
    }

    public boolean hasRemovedElements() {
        return this.removedElements != null && !this.removedElements.isEmpty();
    }

    public boolean hasDeferredChanges() {
        return this.hasRemovedElements() || this.hasAddedElements();
    }

    protected boolean shouldAvoidInstantiation() {
        return !this.isInstantiated() && this._persistence_getPropertyChangeListener() instanceof AttributeChangeListener;
    }
}

