/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.codegen.AccessLevel;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.helper.Helper;

public abstract class CodeDefinition {
    protected AccessLevel accessLevel = new AccessLevel();
    protected String name = "";
    protected String comment = "";
    protected static final String JAVA_LANG_PACKAGE_NAME = "java.lang";
    protected static final String JAVA_UTIL_PACKAGE_NAME = "java.util";
    protected static final String TOPLINK_INDIRECTION_PACKAGE_NAME = "org.eclipse.persistence.indirection";

    private static boolean adjustmentNeededForType(String string, Map map) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (CodeDefinition.packageName(string).length() == 0) {
            return false;
        }
        Set set = (Set)map.get(CodeDefinition.shortName(string));
        return set == null || set.size() <= 1;
    }

    protected static String adjustTypeName(String string, Map map) {
        if (CodeDefinition.adjustmentNeededForType(string, map)) {
            CodeDefinition.putTypeNameInMap(string, map);
            return string.substring(CodeDefinition.packageName(string).length() + 1);
        }
        return string;
    }

    protected static Set parseForTypeNames(String string) {
        HashSet hashSet = new HashSet();
        if (string != null) {
            hashSet.addAll(CodeDefinition.parseForTypeNamesInPackage(string, JAVA_LANG_PACKAGE_NAME));
            hashSet.addAll(CodeDefinition.parseForTypeNamesInPackage(string, JAVA_UTIL_PACKAGE_NAME));
            hashSet.addAll(CodeDefinition.parseForTypeNamesInPackage(string, TOPLINK_INDIRECTION_PACKAGE_NAME));
        }
        return hashSet;
    }

    private static Set parseForTypeNamesInPackage(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = string.indexOf(string2);
        while (n != -1) {
            boolean bl = true;
            int n2 = n + string2.length() + 1;
            while (bl) {
                if (Character.isJavaIdentifierPart(string.charAt(n2))) {
                    ++n2;
                    continue;
                }
                bl = false;
            }
            hashSet.add(string.substring(n, n2));
            n = string.indexOf(string2, n2);
        }
        return hashSet;
    }

    protected static void putTypeNameInMap(String string, Map map) {
        if (string == null || string.equals("")) {
            return;
        }
        String string2 = CodeDefinition.shortName(string);
        String string3 = CodeDefinition.packageName(string);
        if (string3.length() > 0) {
            Set<String> set;
            if (map.get(string2) == null) {
                set = new HashSet();
                map.put(string2, set);
            } else {
                set = (Set)map.get(string2);
            }
            if (!set.contains(string3)) {
                set.add(string3);
            }
        }
    }

    private static String packageName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    private static String shortName(String string) {
        int n;
        int n2 = n = string.lastIndexOf(".") + 1;
        boolean bl = true;
        while (bl) {
            if (Character.isJavaIdentifierPart(string.charAt(n2))) {
                bl = ++n2 < string.length();
                continue;
            }
            bl = false;
        }
        return string.substring(n, n2);
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        CodeGenerator codeGenerator = new CodeGenerator();
        this.write(codeGenerator);
        return codeGenerator.toString();
    }

    public void write(CodeGenerator codeGenerator) {
        if (this.getComment().length() > 0) {
            codeGenerator.writeln("/**");
            String string = this.getComment();
            String string2 = Helper.cr();
            int n = 0;
            int n2 = string.indexOf(string2);
            while (n2 != -1) {
                codeGenerator.write(" * ");
                codeGenerator.write(string.substring(n, n2 + string2.length()));
                n = n2 + string2.length();
                n2 = string.indexOf(string2, n);
            }
            codeGenerator.write(" * ");
            codeGenerator.writeln(string.substring(n, string.length()));
            codeGenerator.writeln(" */");
            codeGenerator.cr();
        }
        this.getAccessLevel().write(codeGenerator);
        codeGenerator.write(" ");
        this.writeBody(codeGenerator);
    }

    public abstract void writeBody(CodeGenerator var1);
}

